/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.time.NightUtils;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.FlyingUsePortalGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface Unit {
    public static final int ANCHOR_RETREAT_RANGE = 30;
    public static final int PIGLIN_HEALING_TICKS = 160;
    public static final int MONSTER_HEALING_TICKS = 240;
    public static final int FOLLOW_RANGE_IMPROVED = 64;
    public static final int FOLLOW_RANGE = 16;
    public static final List<Keybinding> ABILITY_KEYBINDS = List.of(Keybindings.keyQ, Keybindings.keyW, Keybindings.keyE, Keybindings.keyR, Keybindings.keyT, Keybindings.keyY);

    public void setAnchor(BlockPos var1);

    public BlockPos getAnchor();

    public static int getFollowRange() {
        return UnitServerEvents.improvedPathfinding ? 64 : 16;
    }

    public ArrayList<Checkpoint> getCheckpoints();

    public GarrisonGoal getGarrisonGoal();

    public boolean canGarrison();

    public MoveToTargetBlockGoal getUsePortalGoal();

    public boolean canUsePortal();

    public Faction getFaction();

    public List<AbilityButton> getAbilityButtons();

    public List<Ability> getAbilities();

    public List<ItemStack> getItems();

    public int getMaxResources();

    default public void updateAbilityButtons() {
        if (((LivingEntity)this).m_9236_().m_5776_()) {
            this.getAbilityButtons().clear();
            for (int i = 0; i < this.getAbilities().size() && i < ABILITY_KEYBINDS.size(); ++i) {
                this.getAbilityButtons().add(this.getAbilities().get(i).getButton(ABILITY_KEYBINDS.get(i)));
            }
        }
    }

    public MoveToTargetBlockGoal getMoveGoal();

    public SelectedTargetGoal<?> getTargetGoal();

    public ReturnResourcesGoal getReturnResourcesGoal();

    public float getMovementSpeed();

    public float getUnitMaxHealth();

    public float getUnitArmorValue();

    public ResourceCost getCost();

    public LivingEntity getFollowTarget();

    public boolean getHoldPosition();

    public void setHoldPosition(boolean var1);

    public String getOwnerName();

    public void setOwnerName(String var1);

    public static void tick(Unit unit) {
        LivingEntity le;
        Level level;
        Mob unitMob = (Mob)unit;
        if (!unitMob.m_9236_().m_5776_() && (level = unitMob.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerChunkCache serverChunkCache = serverLevel.m_7726_();
            BlockPos unitPos = unitMob.m_20183_();
            ChunkPos currentChunkPos = new ChunkPos(unitPos);
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    ChunkPos chunkPos = new ChunkPos(currentChunkPos.f_45578_ + dx, currentChunkPos.f_45579_ + dz);
                    serverChunkCache.m_8387_(TicketType.f_9445_, chunkPos, 2, (Object)chunkPos);
                }
            }
        }
        for (Ability ability : unit.getAbilities()) {
            ability.tickCooldown();
        }
        if (unitMob.m_9236_().m_5776_()) {
            unit.getCheckpoints().removeIf(c -> c.isForEntity() && !c.entity.m_6084_() || c.ticksLeft <= 0);
            for (Checkpoint checkpoint : unit.getCheckpoints()) {
                checkpoint.tick();
                boolean buildingIsDone = false;
                if (unit instanceof WorkerUnit) {
                    WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                    if (!checkpoint.isForEntity() && checkpoint.building != null && checkpoint.building.isBuilt && checkpoint.building.getHealth() >= checkpoint.building.getMaxHealth()) {
                        buildingIsDone = true;
                    }
                }
                if (!(((Mob)unit).m_20097_().m_203193_((Position)checkpoint.getPos()) < 4.0) && !buildingIsDone) continue;
                checkpoint.startFading();
            }
        } else {
            boolean bl;
            int totalRes = Resources.getTotalResourcesFromItems(unit.getItems()).getTotalValue();
            if (unitMob.m_21531_()) {
                for (ItemEntity itementity : unitMob.m_9236_().m_45976_(ItemEntity.class, unitMob.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                    WorkerUnit workerUnit;
                    GatherResourcesGoal goal;
                    if (itementity.m_213877_() || itementity.m_32055_().m_41619_() || itementity.m_32063_() || !unitMob.m_6084_() || Unit.atMaxResources(unit)) continue;
                    ItemStack itemstack = itementity.m_32055_();
                    ResourceSource resBlock = ResourceSources.getFromItem(itemstack.m_41720_());
                    if (resBlock != null) {
                        while (!Unit.atMaxResources(unit) && itemstack.m_41613_() > 0) {
                            unitMob.m_21053_(itementity);
                            unitMob.m_7938_((Entity)itementity, 1);
                            unit.getItems().add(new ItemStack((ItemLike)itemstack.m_41720_(), 1));
                            itemstack.m_41764_(itemstack.m_41613_() - 1);
                        }
                        if (itemstack.m_41613_() <= 0) {
                            itementity.m_146870_();
                        }
                        UnitSyncClientboundPacket.sendSyncResourcesPacket(unit);
                    }
                    if (!Unit.atThresholdResources(unit) || !(unit instanceof WorkerUnit) || (goal = (workerUnit = (WorkerUnit)((Object)unit)).getGatherResourceGoal()) == null || goal.getTargetResourceName() == ResourceName.NONE) continue;
                    goal.saveAndReturnResources();
                }
            }
            if (unit.getTargetGoal().getTarget() == null || !unit.getTargetGoal().getTarget().m_6084_() || unitMob.m_5448_() == null || !unitMob.m_5448_().m_6084_()) {
                unitMob.m_6710_(null);
                unit.getTargetGoal().setTarget(null);
            }
            unitMob.f_19802_ = 0;
            if (unit.getFollowTarget() != null && unitMob.f_19797_ % 20 == 0) {
                unit.setMoveTarget(unit.getFollowTarget().m_20183_());
            }
            if ((bl = ResearchServerEvents.playerHasResearch(unit.getOwnerName(), "Fire Resistance")) && unit.getFaction() == Faction.PIGLINS) {
                unitMob.m_7311_(0);
            }
        }
        if (!(le = (LivingEntity)unit).m_9236_().m_5776_()) {
            if (unit.getFaction() == Faction.MONSTERS && le.f_19797_ % 240 == 0 && !le.m_9236_().m_46461_()) {
                le.m_5634_(1.0f);
            } else if (unit.getFaction() == Faction.MONSTERS && (le.f_19797_ + 120) % 240 == 0 && NightUtils.isInRangeOfNightSource(le.m_20182_(), le.m_9236_().m_5776_())) {
                le.m_5634_(1.0f);
            } else if (unit.getFaction() == Faction.PIGLINS && le.f_19797_ % 160 == 0 && !(unit instanceof Slime) && (le.m_20202_() != null && NetherBlocks.isNetherBlock(le.m_9236_(), le.m_20202_().m_20097_()) || NetherBlocks.isNetherBlock(le.m_9236_(), le.m_20097_()) || unit instanceof GhastUnit)) {
                le.m_5634_(1.0f);
            }
        }
        if (le.m_20069_() && BuildingUtils.findBuilding(le.m_9236_().m_5776_(), le.m_20097_().m_7494_()) instanceof AbstractBridge) {
            le.m_20334_(0.0, 0.2, 0.0);
        }
        if (!le.m_9236_().m_6857_().m_61937_(le.m_20097_())) {
            le.m_6074_();
        }
        if (unitMob.f_19797_ % 20 == 0) {
            Unit.checkAndRetreatToAnchor(unit);
        }
    }

    public static boolean hasAnchor(Unit unit) {
        return unit.getAnchor() != null && !unit.getAnchor().equals((Object)new BlockPos(0, 0, 0));
    }

    private static void checkAndRetreatToAnchor(Unit unit) {
        LivingEntity le = (LivingEntity)unit;
        if (!Unit.hasAnchor(unit) || le.m_9236_().m_5776_()) {
            return;
        }
        if ((unit.isIdle() || le.m_20238_(Vec3.m_82512_((Vec3i)unit.getAnchor())) > 900.0) && !le.m_20097_().equals((Object)unit.getAnchor())) {
            Unit.fullResetBehaviours(unit);
            unit.getMoveGoal().setMoveTarget(unit.getAnchor());
        }
    }

    private static int getThresholdResources(Unit unit) {
        boolean hasCarryBags = ((LivingEntity)unit).m_9236_().m_5776_() ? ResearchClient.hasResearch("Worker Carry Bags") : ResearchServerEvents.playerHasResearch(unit.getOwnerName(), "Worker Carry Bags");
        return hasCarryBags ? 100 : 50;
    }

    public static boolean atMaxResources(Unit unit) {
        return Resources.getTotalResourcesFromItems(unit.getItems()).getTotalValue() >= unit.getMaxResources();
    }

    public static boolean atThresholdResources(Unit unit) {
        return Resources.getTotalResourcesFromItems(unit.getItems()).getTotalValue() >= Unit.getThresholdResources(unit);
    }

    default public boolean hasLivingTarget() {
        Mob unitMob = (Mob)this;
        return unitMob.m_5448_() != null && unitMob.m_5448_().m_6084_();
    }

    public static void fullResetBehaviours(Unit unit) {
        if (((Entity)unit).m_9236_().m_5776_() && !Keybindings.shiftMod.isDown()) {
            unit.getCheckpoints().clear();
        }
        unit.resetBehaviours();
        Unit.resetBehaviours(unit);
        if (unit instanceof WorkerUnit) {
            WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
            WorkerUnit.resetBehaviours(workerUnit);
        }
        if (unit instanceof AttackerUnit) {
            AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
            AttackerUnit.resetBehaviours(attackerUnit);
        }
    }

    public static void resetBehaviours(Unit unit) {
        unit.getTargetGoal().setTarget(null);
        unit.getMoveGoal().stopMoving();
        if (unit.getReturnResourcesGoal() != null) {
            unit.getReturnResourcesGoal().stopReturning();
        }
        unit.setFollowTarget(null);
        unit.setHoldPosition(false);
        if (unit.canGarrison()) {
            unit.getGarrisonGoal().stopGarrisoning();
        }
        if (unit.canUsePortal()) {
            MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getUsePortalGoal();
            if (moveToTargetBlockGoal instanceof FlyingUsePortalGoal) {
                FlyingUsePortalGoal flyingUsePortalGoal = (FlyingUsePortalGoal)moveToTargetBlockGoal;
                flyingUsePortalGoal.stopUsingPortal();
            }
            if ((moveToTargetBlockGoal = unit.getUsePortalGoal()) instanceof UsePortalGoal) {
                UsePortalGoal usePortalGoal = (UsePortalGoal)moveToTargetBlockGoal;
                usePortalGoal.stopUsingPortal();
            }
        }
    }

    default public void resetBehaviours() {
    }

    default public void setMoveTarget(@Nullable BlockPos bp) {
        this.getMoveGoal().setMoveTarget(bp);
    }

    public void setFollowTarget(@Nullable LivingEntity var1);

    public void initialiseGoals();

    default public void setupEquipmentAndUpgradesServer() {
    }

    default public void setupEquipmentAndUpgradesClient() {
    }

    public static float getSpeedModifier(Unit unit) {
        if (unit instanceof BruteUnit) {
            BruteUnit brute = (BruteUnit)unit;
            if (brute.isHoldingUpShield) {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    public static Ability getAbility(Unit unit, UnitAction abilityAction) {
        for (Ability ability : unit.getAbilities()) {
            if (!ability.action.equals((Object)abilityAction)) continue;
            return ability;
        }
        return null;
    }

    default public boolean isIdle() {
        boolean idleAttacker = true;
        Unit unit = this;
        if (unit instanceof AttackerUnit) {
            AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
            idleAttacker = attackerUnit.getAttackMoveTarget() == null && !((Unit)((Object)attackerUnit)).hasLivingTarget();
        }
        boolean idleWorker = true;
        if (this instanceof WorkerUnit) {
            idleWorker = WorkerUnit.isIdle((WorkerUnit)((Object)this));
        }
        return this.getMoveGoal().getMoveTarget() == null && this.getFollowTarget() == null && idleAttacker && idleWorker;
    }
}

