/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitSyncWorkerClientBoundPacket {
    private final int entityId;
    private final boolean isBuilding;
    private final ResourceName gatherName;
    private final BlockPos gatherPos;
    private final int gatherTicks;

    public static void sendSyncWorkerPacket(LivingEntity entity) {
        if (entity instanceof WorkerUnit) {
            WorkerUnit workerUnit = (WorkerUnit)entity;
            BlockPos bp = workerUnit.getGatherResourceGoal().getGatherTarget();
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncWorkerClientBoundPacket(entity.m_19879_(), workerUnit.getBuildRepairGoal().isBuilding(), workerUnit.getGatherResourceGoal().getTargetResourceName(), bp == null ? new BlockPos(0, 0, 0) : bp, workerUnit.getGatherResourceGoal().getGatherTicksLeft()));
        }
    }

    public UnitSyncWorkerClientBoundPacket(int unitId, boolean isBuilding, ResourceName gatherName, BlockPos gatherPos, int gatherTicks) {
        this.entityId = unitId;
        this.isBuilding = isBuilding;
        this.gatherName = gatherName;
        this.gatherPos = gatherPos;
        this.gatherTicks = gatherTicks;
    }

    public UnitSyncWorkerClientBoundPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.isBuilding = buffer.readBoolean();
        this.gatherName = (ResourceName)buffer.m_130066_(ResourceName.class);
        this.gatherPos = buffer.m_130135_();
        this.gatherTicks = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.isBuilding);
        buffer.m_130068_((Enum)this.gatherName);
        buffer.m_130064_(this.gatherPos);
        buffer.writeInt(this.gatherTicks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UnitClientEvents.syncWorkerUnit(this.entityId, this.isBuilding, this.gatherName, this.gatherPos.equals((Object)new BlockPos(0, 0, 0)) ? null : this.gatherPos, this.gatherTicks)));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

