/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.SonicBoom;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.buildings.monsters.SculkCatalyst;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.time.NightUtils;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.SonicBoomGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class WardenUnit
extends Warden
implements Unit,
AttackerUnit {
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(WardenUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final float attackDamage = 8.0f;
    public static final float attacksPerSecond = 0.6f;
    public static final float maxHealth = 150.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private SonicBoomGoal sonicBoomGoal;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public static final float SONIC_BOOM_DAMAGE = 75.0f;
    public static final int SONIC_BOOM_RANGE = 10;
    public static final int SONIC_BOOM_CHANNEL_TICKS = 40;

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return null;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 33;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.6f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 8.0f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 150.0f;
    }

    @Override
    public float getUnitArmorValue() {
        return 0.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.WARDEN;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    public SonicBoomGoal getSonicBoomGoal() {
        return this.sonicBoomGoal;
    }

    public WardenUnit(EntityType<? extends Warden> entityType, Level level) {
        super(entityType, level);
        this.abilities.add(new SonicBoom(this));
        this.updateAbilityButtons();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.5);
    }

    protected void m_8024_() {
    }

    public void m_219387_(@Nullable Entity pEntity, int pOffset, boolean pPlayListeningSound) {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_219459_(LivingEntity pAttackTarget) {
    }

    public void m_8119_() {
        this.m_21553_(false);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        this.sonicBoomGoal.m_8037_();
        if (this.f_19797_ % 10 == 0 && !this.m_9236_().m_5776_() && this.m_9236_().m_46461_() && !NightUtils.isInRangeOfNightSource(this.m_146892_(), false) && !ResearchServerEvents.playerHasCheat(this.getOwnerName(), "slipslopslap")) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 15, 1));
        }
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, false);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.sonicBoomGoal = new SonicBoomGoal((Mob)this, 40, 10, this::doEntitySonicBoom, this::doBuildingSonicBoom);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.sonicBoomGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void resetBehaviours() {
        this.f_219314_.m_216973_();
        this.sonicBoomGoal.m_8041_();
    }

    public void doEntitySonicBoom(LivingEntity targetEntity) {
        this.doEntitySonicBoom(targetEntity, this.m_20182_().m_82520_(0.0, 1.6, 0.0), 1.0f);
    }

    public void doEntitySonicBoom(LivingEntity targetEntity, Vec3 startPos, float damageMult) {
        Vec3 targetPos = targetEntity.m_146892_().m_82546_(startPos);
        Vec3 normTargetPos = targetPos.m_82541_();
        this.m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            ServerLevel level = (ServerLevel)this.m_9236_();
            for (int i = 1; i < Mth.m_14107_((double)targetPos.m_82553_()) + 7; ++i) {
                Vec3 particlePos = startPos.m_82549_(normTargetPos.m_82490_((double)i));
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        targetEntity.m_6469_(this.m_269291_().m_269285_((Entity)this), 75.0f * damageMult);
        double knockbackY = 0.5 * (1.0 - targetEntity.m_21133_(Attributes.f_22278_));
        double knockbackXZ = 2.0 * (1.0 - targetEntity.m_21133_(Attributes.f_22278_));
        targetEntity.m_5997_(normTargetPos.m_7096_() * knockbackXZ, normTargetPos.m_7098_() * knockbackY, normTargetPos.m_7094_() * knockbackXZ);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void doBuildingSonicBoom(Building targetBuilding) {
        boolean hasResearch;
        Vec3 startPos = this.m_20182_().m_82520_(0.0, 1.6, 0.0);
        Vec3 targetPos = new Vec3((double)((float)targetBuilding.centrePos.m_123341_() + 0.5f), (double)((float)targetBuilding.minCorner.m_123342_() + 1.5f), (double)((float)targetBuilding.centrePos.m_123343_() + 0.5f)).m_82546_(startPos);
        Vec3 normTargetPos = targetPos.m_82541_();
        this.m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            ServerLevel level = (ServerLevel)this.m_9236_();
            for (int i = 1; i < Mth.m_14107_((double)targetPos.m_82553_()) + 7; ++i) {
                Vec3 particlePos = startPos.m_82549_(normTargetPos.m_82490_((double)i));
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if ((hasResearch = this.m_9236_().m_5776_() ? ResearchClient.hasResearch("Sculk Amplifiers") : ResearchServerEvents.playerHasResearch(this.getOwnerName(), "Sculk Amplifiers")) && targetBuilding instanceof SculkCatalyst) {
            SculkCatalyst catalyst = (SculkCatalyst)targetBuilding;
            if (catalyst.isBuilt) {
                List<Mob> nearbyEnemies = MiscUtil.getEntitiesWithinRange(new Vector3d((double)targetBuilding.centrePos.m_123341_(), (double)targetBuilding.centrePos.m_123342_(), (double)targetBuilding.centrePos.m_123343_()), 20.0f, Mob.class, this.m_9236_()).stream().filter(mob -> {
                    if (!(mob instanceof Unit)) return false;
                    Unit unit = (Unit)mob;
                    if (UnitServerEvents.getUnitToEntityRelationship(this, (Entity)mob) != Relationship.HOSTILE) return false;
                    return true;
                }).toList();
                int i = 0;
                while (i < 3) {
                    if (nearbyEnemies.size() > i) {
                        this.doEntitySonicBoom((LivingEntity)nearbyEnemies.get(i), Vec3.m_82512_((Vec3i)targetBuilding.centrePos), 0.666f);
                    }
                    ++i;
                }
                return;
            }
        }
        int damage = (int)(37.5f * targetBuilding.getMagicDamageMult());
        targetBuilding.destroyRandomBlocks(damage);
    }

    public void startSonicBoomAnimation() {
        this.f_219314_.m_216977_(this.f_19797_);
    }

    public void stopSonicBoomAnimation() {
        this.f_219314_.m_216973_();
    }
}

