/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class MagmaCubeProd
extends ProductionItem {
    public static final String itemName = "Magma Cube";
    public static final ResourceCost cost = ResourceCosts.MAGMA_CUBE;

    public MagmaCubeProd(ProductionBuilding building) {
        super(building, MagmaCubeProd.cost.ticks);
        this.onComplete = level -> {
            if (!level.m_5776_()) {
                building.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.MAGMA_CUBE_UNIT.get()), building.ownerName, true);
            }
        };
        this.foodCost = MagmaCubeProd.cost.food;
        this.woodCost = MagmaCubeProd.cost.wood;
        this.oreCost = MagmaCubeProd.cost.ore;
        this.popCost = MagmaCubeProd.cost.population;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public static AbilityButton getPlaceButton() {
        return new AbilityButton(itemName, new ResourceLocation("reignofnether", "textures/mobheads/magma_cube.png"), null, () -> SandboxClientEvents.spawnUnitName.equals(itemName), () -> false, () -> true, () -> {
            CursorClientEvents.setLeftClickSandboxAction(SandboxAction.SPAWN_UNIT);
            SandboxClientEvents.spawnUnitName = itemName;
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    public static Button getStartButton(ProductionBuilding prodBuilding, Keybinding hotkey) {
        ArrayList<FormattedCharSequence> tooltipLines = new ArrayList<FormattedCharSequence>(List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPopAndTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.piglins.reignofnether.magma_cube.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)));
        return new Button(itemName, 14, new ResourceLocation("reignofnether", "textures/mobheads/magma_cube.png"), hotkey, () -> false, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Basalt Springs"), () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, itemName), null, tooltipLines);
    }

    @Override
    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("reignofnether", "textures/mobheads/magma_cube.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.originPos, itemName, first), null, null);
    }
}

