/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.blocks.BlockServerEvents;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SlimeUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MagmaCubeUnit
extends SlimeUnit
implements Unit,
AttackerUnit {
    private static final int SET_FIRE_TICKS_MAX = 20;
    private int setFireTicks = 0;
    private static final int FIRE_DURATION_PER_SIZE = 40;
    private static final int MAGMA_DURATION = 100;

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123744_;
    }

    public boolean m_6060_() {
        return false;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    public MagmaCubeUnit(EntityType<? extends SlimeUnit> entityType, Level level) {
        super(entityType, level);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.m_33633_() ? SoundEvents.f_12110_ : SoundEvents.f_12109_;
    }

    protected SoundEvent m_5592_() {
        return this.m_33633_() ? SoundEvents.f_12101_ : SoundEvents.f_12108_;
    }

    protected SoundEvent m_7905_() {
        return this.m_33633_() ? SoundEvents.f_12061_ : SoundEvents.f_12112_;
    }

    @Override
    protected void spawnTinySlime() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            ++this.setFireTicks;
            if (this.setFireTicks >= 20) {
                this.setFireTicks = 0;
                this.createMagma();
            }
        }
    }

    @Override
    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        super.m_7840_(pY, pOnGround, pState, pPos);
        if (!this.m_9236_().m_5776_() && pOnGround && !this.f_33583_) {
            this.createMagma();
        }
    }

    @Override
    public boolean m_7327_(@NotNull Entity pEntity) {
        boolean result = super.m_7327_(pEntity);
        if (result && this.m_33632_() >= 2) {
            pEntity.m_7311_(40 * this.m_33632_());
        }
        return result;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        AttackerUnit aUnit;
        Entity entity;
        if (this.m_33632_() >= 2 && (entity = pSource.m_7639_()) instanceof AttackerUnit && (aUnit = (AttackerUnit)entity).getAttackGoal() instanceof AbstractMeleeAttackUnitGoal) {
            pSource.m_7639_().m_7311_(40 * this.m_33632_() / 2);
        }
        if (pSource.m_269533_(DamageTypeTags.f_268745_) || pSource == this.m_269291_().m_269233_()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void createMagma() {
        if (this.m_33632_() < 4 || this.m_9236_().m_5776_()) {
            return;
        }
        if (!ResearchServerEvents.playerHasResearch(this.getOwnerName(), "Cube Magma")) {
            return;
        }
        BlockState bsToPlace = ((Block)BlockRegistrar.WALKABLE_MAGMA_BLOCK.get()).m_49966_();
        BlockPos bpOn = this.m_20097_();
        if (this.m_9236_().m_8055_(bpOn).m_60795_()) {
            return;
        }
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        if (this.m_33632_() >= 2) {
            bps.add(bpOn);
        }
        if (this.m_33632_() >= 3) {
            bps.add(bpOn.m_122012_());
            bps.add(bpOn.m_122029_());
            bps.add(bpOn.m_122019_());
            bps.add(bpOn.m_122024_());
        }
        if (this.m_33632_() >= 4) {
            bps.add(bpOn.m_122012_().m_122029_());
            bps.add(bpOn.m_122019_().m_122024_());
            bps.add(bpOn.m_122012_().m_122024_());
            bps.add(bpOn.m_122019_().m_122029_());
        }
        if (this.m_33632_() >= 5) {
            bps.add(bpOn.m_122012_().m_122012_());
            bps.add(bpOn.m_122019_().m_122019_());
            bps.add(bpOn.m_122029_().m_122029_());
            bps.add(bpOn.m_122024_().m_122024_());
        }
        if (this.m_33632_() >= 6) {
            bps.add(bpOn.m_122012_().m_122012_().m_122029_());
            bps.add(bpOn.m_122019_().m_122019_().m_122029_());
            bps.add(bpOn.m_122012_().m_122012_().m_122024_());
            bps.add(bpOn.m_122019_().m_122019_().m_122024_());
            bps.add(bpOn.m_122029_().m_122029_().m_122019_());
            bps.add(bpOn.m_122024_().m_122024_().m_122019_());
            bps.add(bpOn.m_122029_().m_122029_().m_122012_());
            bps.add(bpOn.m_122024_().m_122024_().m_122012_());
        }
        for (BlockPos bp : bps) {
            BlockState bsOld = this.m_9236_().m_8055_(bp);
            if (!MiscUtil.isSolidBlocking(this.m_9236_(), bp)) continue;
            BlockServerEvents.addTempBlock((ServerLevel)this.m_9236_(), bp, ((Block)BlockRegistrar.WALKABLE_MAGMA_BLOCK.get()).m_49966_(), bsOld, 100);
        }
    }

    public void createFire() {
        if (this.m_33632_() < 6 || this.m_9236_().m_5776_()) {
            return;
        }
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        for (int x = -4; x < 4; ++x) {
            for (int y = -4; y < 4; ++y) {
                for (int z = -4; z < 4; ++z) {
                    if (this.m_9236_().m_8055_(this.m_20097_().m_7918_(x, y, z)).m_60734_() != BlockRegistrar.WALKABLE_MAGMA_BLOCK.get() || !this.m_9236_().m_8055_(this.m_20097_().m_7918_(x, y + 1, z)).m_60795_()) continue;
                    bps.add(this.m_20097_().m_7918_(x, y, z));
                }
            }
        }
        Collections.shuffle(bps);
        if (bps.size() >= 1) {
            this.m_9236_().m_46597_(((BlockPos)bps.get(0)).m_7494_(), Blocks.f_50083_.m_49966_());
        }
    }
}

