/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.villagers;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.MountRavager;
import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MountGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.RangedAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UnitCrossbowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PillagerUnit
extends Pillager
implements Unit,
AttackerUnit,
RangedAttackerUnit {
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    public MountGoal mountGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(PillagerUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final float attackDamage = 7.0f;
    public static final float attacksPerSecond = 0.8f;
    public static final float maxHealth = 45.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.25f;
    public static final float attackRange = 16.0f;
    public static final float aggroRange = 16.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    public int fogRevealDuration = 0;
    private UnitCrossbowAttackGoal<? extends LivingEntity> attackGoal;
    private RangedAttackBuildingGoal<?> attackBuildingGoal;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public MountGoal getMountGoal() {
        return this.mountGoal;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 25;
    }

    @Override
    public float getAttacksPerSecond() {
        return 20.0f / (float)(this.getAttackCooldown() + 25);
    }

    @Override
    public float getAggroRange() {
        return 16.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 16.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.25f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 7.0f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 45.0f;
    }

    @Override
    public float getUnitArmorValue() {
        return 0.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.PILLAGER;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null && this.m_20159_();
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getFogRevealDuration() {
        return this.fogRevealDuration;
    }

    @Override
    public void setFogRevealDuration(int duration) {
        this.fogRevealDuration = duration;
    }

    public PillagerUnit(EntityType<? extends Pillager> entityType, Level level) {
        super(entityType, level);
        this.abilities.add(new MountRavager((LivingEntity)this));
        this.updateAbilityButtons();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        this.mountGoal.m_8037_();
        PromoteIllager.checkAndApplyBuff((LivingEntity)this);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, false);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new UnitCrossbowAttackGoal<PillagerUnit>(this, this.getAttackCooldown());
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.mountGoal = new MountGoal((Mob)this);
        this.attackBuildingGoal = new RangedAttackBuildingGoal<PillagerUnit>(this, this.attackGoal);
    }

    @Override
    public void resetBehaviours() {
        this.mountGoal.m_8041_();
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.mountGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        if (this.hasAnyEnchant()) {
            return;
        }
        ItemStack cbowStack = new ItemStack((ItemLike)Items.f_42717_);
        this.m_8061_(EquipmentSlot.MAINHAND, cbowStack);
    }

    public boolean hasAnyEnchant() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return !itemStack.getAllEnchantments().isEmpty();
    }

    public Enchantment getEnchant() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        Optional enchant = itemStack.getAllEnchantments().keySet().stream().findFirst();
        return enchant.orElse(null);
    }

    public void m_32336_(LivingEntity pUser, float pVelocity) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)pUser, item -> item instanceof CrossbowItem);
        ItemStack itemstack = pUser.m_21120_(interactionhand);
        if (pUser.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            CrossbowItem.m_40887_((Level)pUser.m_9236_(), (LivingEntity)pUser, (InteractionHand)interactionhand, (ItemStack)itemstack, (float)pVelocity, (float)0.0f);
            this.m_5496_(SoundEvents.f_11847_, 3.0f, 0.0f);
        }
        this.m_5847_();
    }

    public void m_32322_(LivingEntity pUser, LivingEntity pTarget, Projectile pProjectile, float pProjectileAngle, float pVelocity) {
        try {
            Goal goal;
            if (pTarget == null && (goal = this.getAttackBuildingGoal()) instanceof RangedAttackBuildingGoal) {
                RangedAttackBuildingGoal rabg = (RangedAttackBuildingGoal)goal;
                this.shootCrossbowProjectileAtBuilding(pUser, rabg, pProjectile, pProjectileAngle, pVelocity);
                return;
            }
        }
        catch (NullPointerException e) {
            System.out.println("Caught NullPointerException in shootCrossbowProjectile: " + e.getMessage());
        }
        if (pTarget == null) {
            return;
        }
        double d0 = pTarget.m_20185_() - pUser.m_20185_();
        double d1 = pTarget.m_20189_() - pUser.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = pTarget.m_20227_(0.3333333333333333) - pProjectile.m_20186_() + d2 * (double)0.2f;
        if (pTarget.m_20192_() <= 1.0f) {
            d1 -= (double)(1.0f - pTarget.m_20192_());
        }
        Vector3f vector3f = this.m_252851_(pUser, new Vec3(d0, d3, d1), pProjectileAngle);
        pProjectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, (float)(14 - pUser.m_9236_().m_46791_().m_19028_() * 4));
        pUser.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (pUser.m_217043_().m_188501_() * 0.4f + 0.8f));
        if (!this.m_9236_().m_5776_() && pTarget instanceof Unit) {
            Unit unit = (Unit)pTarget;
            FogOfWarClientboundPacket.revealRangedUnit(unit.getOwnerName(), this.m_19879_());
        }
    }

    private void shootCrossbowProjectileAtBuilding(LivingEntity pUser, RangedAttackBuildingGoal<?> rabg, Projectile pProjectile, float pProjectileAngle, float pVelocity) {
        if (rabg.getBuildingTarget() == null) {
            return;
        }
        double d0 = (double)rabg.getBuildingTarget().centrePos.m_123341_() - pUser.m_20185_();
        double d1 = (double)rabg.getBuildingTarget().centrePos.m_123343_() - pUser.m_20189_();
        double d3 = rabg.getBuildingTarget().centrePos.m_123342_();
        Vector3f vector3f = this.m_252851_(pUser, new Vec3(d0, d3, d1), pProjectileAngle);
        pProjectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, (float)(14 - pUser.m_9236_().m_46791_().m_19028_() * 4));
        pUser.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (pUser.m_217043_().m_188501_() * 0.4f + 0.8f));
        if (!this.m_9236_().m_5776_()) {
            FogOfWarClientboundPacket.revealRangedUnit(rabg.getBuildingTarget().ownerName, this.m_19879_());
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }
}

