/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.villagers;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.ability.heroAbilities.villager.Avatar;
import com.solegendary.reignofnether.ability.heroAbilities.villager.BattleRagePassive;
import com.solegendary.reignofnether.ability.heroAbilities.villager.MaceSlam;
import com.solegendary.reignofnether.ability.heroAbilities.villager.TauntingCry;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.modelling.animations.RoyalGuardAnimations;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class RoyalGuardUnit
extends Vindicator
implements Unit,
AttackerUnit,
HeroUnit,
KeyframeAnimated {
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private GenericUntargetedSpellGoal castTauntingCryGoal;
    private GenericTargetedSpellGoal castMaceSlamGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(RoyalGuardUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int skillPoints = 1;
    private int experience = 0;
    private boolean rankUpMenuOpen = false;
    public static final float attackDamage = 6.0f;
    public static final float attackBonusPerLevel = 0.6f;
    public static final float attacksPerSecond = 0.5f;
    public static final float maxHealth = 125.0f;
    public static final float maxHealthBonusPerLevel = 15.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public final AnimationState idleAnimState = new AnimationState();
    public final AnimationState walkAnimState = new AnimationState();
    public final AnimationState spellChargeAnimState = new AnimationState();
    public final AnimationState spellActivateAnimState = new AnimationState();
    public final AnimationState attackAnimState = new AnimationState();
    private static final int ATTACK_WINDUP_TICKS = 2;
    public AnimationDefinition activeAnimDef = null;
    public AnimationState activeAnimState = null;
    public int animateTicks = 0;
    public float animateScale = 1.0f;
    public boolean animateScaleReducing = false;

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public GenericUntargetedSpellGoal getCastTauntingCryGoal() {
        return this.castTauntingCryGoal;
    }

    public GenericTargetedSpellGoal getCastMaceSlamGoal() {
        return this.castMaceSlamGoal;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 40;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 6.0f + 0.6f * (float)this.getHeroLevel();
    }

    @Override
    public float getUnitMaxHealth() {
        return 125.0f + 15.0f * (float)this.getHeroLevel();
    }

    @Override
    public float getUnitArmorValue() {
        return 0.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.VINDICATOR;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int points) {
        this.skillPoints = points;
    }

    @Override
    public boolean isRankUpMenuOpen() {
        return this.rankUpMenuOpen;
    }

    @Override
    public void showRankUpMenu(boolean show) {
        this.rankUpMenuOpen = show;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    @Override
    public void setExperience(int amount) {
        this.experience = amount;
        this.setStatsForLevel();
    }

    @Override
    public float getHealthBonusPerLevel() {
        return 15.0f;
    }

    @Override
    public float getAttackBonusPerLevel() {
        return 125.0f;
    }

    @Override
    public float getBaseHealth() {
        return 125.0f;
    }

    @Override
    public float getBaseAttack() {
        return 6.0f;
    }

    @Override
    public void stopAllAnimations() {
        this.idleAnimState.m_216973_();
        this.walkAnimState.m_216973_();
        this.spellChargeAnimState.m_216973_();
        this.spellActivateAnimState.m_216973_();
        this.attackAnimState.m_216973_();
    }

    @Override
    public void setAnimateTicksLeft(int ticks) {
        this.animateTicks = ticks;
    }

    @Override
    public int getAnimateTicksLeft() {
        return this.animateTicks;
    }

    @Override
    public void playSingleAnimation(UnitAnimationAction animAction) {
        switch (animAction) {
            case ATTACK_UNIT: 
            case ATTACK_BUILDING: {
                this.activeAnimDef = RoyalGuardAnimations.ATTACK;
                this.activeAnimState = this.attackAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case CHARGE_SPELL: {
                this.activeAnimDef = RoyalGuardAnimations.SPELL_CHARGE;
                this.activeAnimState = this.spellChargeAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case CAST_SPELL: {
                this.activeAnimDef = RoyalGuardAnimations.SPELL_ACTIVATE;
                this.activeAnimState = this.spellActivateAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
            }
        }
    }

    public RoyalGuardUnit(EntityType<? extends Vindicator> entityType, Level level) {
        super(entityType, level);
        this.abilities.add(new MaceSlam(this));
        this.abilities.add(new TauntingCry(this));
        this.abilities.add(new BattleRagePassive(this));
        this.abilities.add(new Avatar(this));
        this.updateAbilityButtons();
        this.setStatsForLevel();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22276_, 125.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange());
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        PromoteIllager.checkAndApplyBuff((LivingEntity)this);
        if (this.m_9236_().m_5776_() && this.animateTicks > 0) {
            --this.animateTicks;
        }
        this.castMaceSlamGoal.m_8037_();
        this.castTauntingCryGoal.m_8037_();
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeWindupAttackUnitGoal((Mob)this, false, 2);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.castMaceSlamGoal = new GenericTargetedSpellGoal((Mob)this, 20, 4.0f, UnitAnimationAction.ATTACK_UNIT, null, this::maceSlam, null);
        this.castTauntingCryGoal = new GenericUntargetedSpellGoal((LivingEntity)this, 0, this::tauntingCry, UnitAnimationAction.CHARGE_SPELL, UnitAnimationAction.STOP, UnitAnimationAction.CAST_SPELL);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21346_.m_25352_(3, (Goal)this.moveGoal);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    public void maceSlam(BlockPos blockPos) {
    }

    public void tauntingCry() {
    }

    public void avatar() {
    }
}

