/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.util;

import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class MyMath {
    public static boolean isBetween(double a, double b, double c) {
        return (b - a) * (c - b) >= 0.0;
    }

    public static boolean isPointInsideRect2d(Vec2 m, Vec2 a, Vec2 b, Vec2 c, Vec2 d) {
        float abm = 0.5f * (a.f_82470_ * (b.f_82471_ - m.f_82471_) + b.f_82470_ * (m.f_82471_ - a.f_82471_) + m.f_82470_ * (a.f_82471_ - b.f_82471_));
        float bcm = 0.5f * (b.f_82470_ * (c.f_82471_ - m.f_82471_) + c.f_82470_ * (m.f_82471_ - b.f_82471_) + m.f_82470_ * (b.f_82471_ - c.f_82471_));
        float cdm = 0.5f * (c.f_82470_ * (d.f_82471_ - m.f_82471_) + d.f_82470_ * (m.f_82471_ - c.f_82471_) + m.f_82470_ * (c.f_82471_ - d.f_82471_));
        float dam = 0.5f * (d.f_82470_ * (a.f_82471_ - m.f_82471_) + a.f_82470_ * (m.f_82471_ - d.f_82471_) + m.f_82470_ * (d.f_82471_ - a.f_82471_));
        float area_rect = 0.5f * Math.abs((a.f_82471_ - c.f_82471_) * (d.f_82470_ - b.f_82470_) + (b.f_82471_ - d.f_82471_) * (a.f_82470_ - c.f_82470_));
        return abm + bcm + cdm + dam < area_rect;
    }

    public static ArrayList<Vec3> prepIsPointInsideRect3d(Minecraft MC, int tlx, int tly, int blx, int bly, int brx, int bry) {
        Vector3d tl = MiscUtil.screenPosToWorldPos(MC, tlx, tly);
        Vector3d bl = MiscUtil.screenPosToWorldPos(MC, blx, bly);
        Vector3d br = MiscUtil.screenPosToWorldPos(MC, brx, bry);
        return MyMath.prepIsPointInsideRect3d(MC, tl, bl, br);
    }

    public static ArrayList<Vec3> prepIsPointInsideRect3d(Minecraft MC, Vector3d tl, Vector3d bl, Vector3d br) {
        Vector3d lookVector = MiscUtil.getPlayerLookVector(MC);
        Vec3 p5 = new Vec3(tl.x - 200.0 * lookVector.x, tl.y - 200.0 * lookVector.y, tl.z - 200.0 * lookVector.z);
        Vec3 p1 = new Vec3(bl.x - 200.0 * lookVector.x, bl.y - 200.0 * lookVector.y, bl.z - 200.0 * lookVector.z);
        Vec3 p4 = new Vec3(br.x - 200.0 * lookVector.x, br.y - 200.0 * lookVector.y, br.z - 200.0 * lookVector.z);
        Vec3 p2 = new Vec3(bl.x + 200.0 * lookVector.x, bl.y + 200.0 * lookVector.y, bl.z + 200.0 * lookVector.z);
        Vec3 p1p4 = p1.m_82546_(p4);
        Vec3 p1p5 = p1.m_82546_(p5);
        Vec3 p1p2 = p1.m_82546_(p2);
        Vec3 u = p1p4.m_82537_(p1p5);
        Vec3 v = p1p2.m_82537_(p1p5);
        Vec3 w = p1p2.m_82537_(p1p4);
        ArrayList<Vec3> uvwp = new ArrayList<Vec3>(7);
        uvwp.add(u);
        uvwp.add(v);
        uvwp.add(w);
        uvwp.add(p1);
        uvwp.add(p2);
        uvwp.add(p4);
        uvwp.add(p5);
        return uvwp;
    }

    public static boolean isPointInsideRect3d(List<Vec3> uvwp, Vec3 x) {
        if (uvwp == null || uvwp.size() < 7) {
            return false;
        }
        Vec3 u = uvwp.get(0);
        Vec3 v = uvwp.get(1);
        Vec3 w = uvwp.get(2);
        Vec3 p1 = uvwp.get(3);
        Vec3 p2 = uvwp.get(4);
        Vec3 p4 = uvwp.get(5);
        Vec3 p5 = uvwp.get(6);
        double up1 = u.m_82526_(p1);
        double up2 = u.m_82526_(p2);
        double vp1 = v.m_82526_(p1);
        double vp4 = v.m_82526_(p4);
        double wp1 = w.m_82526_(p1);
        double wp5 = w.m_82526_(p5);
        double ux = u.m_82526_(x);
        double vx = v.m_82526_(x);
        double wx = w.m_82526_(x);
        return MyMath.isBetween(up1, ux, up2) && MyMath.isBetween(vp1, vx, vp4) && MyMath.isBetween(wp1, wx, wp5);
    }

    public static Vector3d addVector3d(Vector3d vec, Vector3d unitVec, float scale) {
        Vector3d unitVecLocal = new Vector3d(0.0, 0.0, 0.0);
        unitVecLocal.set((Vector3dc)unitVec);
        unitVecLocal.mul((double)scale);
        Vector3d vecLocal = new Vector3d(0.0, 0.0, 0.0);
        vecLocal.set((Vector3dc)vec);
        vecLocal.add((Vector3dc)unitVecLocal);
        return vecLocal;
    }

    public static boolean rayIntersectsAABBCustom(Vector3d origin, Vector3d rayVector, AABB aabb) {
        float invDirX = (float)(1.0 / rayVector.x);
        float invDirY = (float)(1.0 / rayVector.y);
        float invDirZ = (float)(1.0 / rayVector.z);
        float t1 = (float)((aabb.f_82288_ - origin.x) * (double)invDirX);
        float t2 = (float)((aabb.f_82291_ - origin.x) * (double)invDirX);
        float t3 = (float)((aabb.f_82289_ - origin.y) * (double)invDirY);
        float t4 = (float)((aabb.f_82292_ - origin.y) * (double)invDirY);
        float t5 = (float)((aabb.f_82290_ - origin.z) * (double)invDirZ);
        float t6 = (float)((aabb.f_82293_ - origin.z) * (double)invDirZ);
        float tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        return tmax >= 0.0f && tmin <= tmax;
    }

    public static Vec2 rotateCoords(float x, float y, double deg) {
        float xRotRads = (float)Math.toRadians(deg);
        float moveXRotated = x * Mth.m_14089_((float)xRotRads) - y * Mth.m_14031_((float)xRotRads);
        float moveyRotated = y * Mth.m_14089_((float)xRotRads) + x * Mth.m_14031_((float)xRotRads);
        return new Vec2(moveXRotated, moveyRotated);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static boolean isPointOnLine(Vec2 pt1, Vec2 pt2, Vec2 ptc, float threshold) {
        boolean isWithinXBounds;
        double dx1 = ptc.f_82470_ - pt1.f_82470_;
        double dy2 = pt2.f_82471_ - pt1.f_82471_;
        double dy1 = ptc.f_82471_ - pt1.f_82471_;
        double dx2 = pt2.f_82470_ - pt1.f_82470_;
        double cross = dx1 * dy2 - dy1 * dx2;
        if (Math.abs(cross) > (double)threshold) {
            return false;
        }
        boolean bl = dx2 >= 0.0 ? pt1.f_82470_ <= ptc.f_82470_ && ptc.f_82470_ <= pt2.f_82470_ : (isWithinXBounds = pt2.f_82470_ <= ptc.f_82470_ && ptc.f_82470_ <= pt1.f_82470_);
        boolean isWithinYBounds = dy2 >= 0.0 ? pt1.f_82471_ <= ptc.f_82471_ && ptc.f_82471_ <= pt2.f_82471_ : pt2.f_82471_ <= ptc.f_82471_ && ptc.f_82471_ <= pt1.f_82471_;
        return isWithinXBounds && isWithinYBounds;
    }

    public static int randRangeInt(int min, int max) {
        int posRandInt = (int)((double)(max - min) * Math.random());
        return posRandInt + min;
    }

    public static BlockPos getXZRangeLimitedBlockPos(BlockPos originPos, BlockPos targetPos, float range) {
        double rangeSquared;
        float x1 = originPos.m_123341_();
        float x2 = targetPos.m_123341_();
        float z1 = originPos.m_123343_();
        double deltaX = x2 - x1;
        float z2 = targetPos.m_123343_();
        double deltaZ = z2 - z1;
        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
        if (distanceSquared <= (rangeSquared = (double)(range * range))) {
            return targetPos;
        }
        double scale = (double)range / Math.sqrt(distanceSquared);
        double x3 = (double)x1 + scale * deltaX;
        double z3 = (double)z1 + scale * deltaZ;
        return new BlockPos((int)x3, originPos.m_123342_(), (int)z3);
    }

    public static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }
}

