/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Ability {
    public final UnitAction action;
    public float cooldownMax;
    public final float range;
    public final float radius;
    public final boolean canTargetEntities;
    public boolean oneClickOneUse;
    public UnitAction autocastEnableAction = null;
    public UnitAction autocastDisableAction = null;
    public int maxCharges = 1;
    private boolean defaultAutocast = false;
    protected Keybinding defaultHotkey = Keybindings.keyQ;

    public void setAutocast(boolean value, Unit unit) {
        unit.setAutocast(value ? this : null);
    }

    public void setAutocast(boolean value, BuildingPlacement placement) {
        placement.setAutocast(value ? this : null);
    }

    public boolean isAutocasting(Unit unit) {
        return unit.hasAutocast(this);
    }

    public boolean isAutocasting(BuildingPlacement placement) {
        return placement.hasAutocast(this);
    }

    public Ability(UnitAction action, int cooldownMax, float range, float radius, boolean canTargetEntities) {
        this.action = action;
        this.cooldownMax = cooldownMax;
        this.range = range;
        this.radius = radius;
        this.canTargetEntities = canTargetEntities;
        this.oneClickOneUse = false;
    }

    public Ability(UnitAction action, int cooldownMax, float range, float radius, boolean canTargetEntities, boolean oneClickOneUse) {
        this.action = action;
        this.cooldownMax = cooldownMax;
        this.range = range;
        this.radius = radius;
        this.canTargetEntities = canTargetEntities;
        this.oneClickOneUse = oneClickOneUse;
    }

    public boolean usesCharges() {
        return this.maxCharges > 1;
    }

    protected void toggleAutocast(Unit unit) {
        if (!((Entity)unit).m_9236_().m_5776_()) {
            return;
        }
        if (this.isAutocasting(unit) && this.autocastDisableAction != null) {
            UnitClientEvents.sendUnitCommand(this.autocastDisableAction);
        } else if (!this.isAutocasting(unit) && this.autocastEnableAction != null) {
            UnitClientEvents.sendUnitCommand(this.autocastEnableAction);
        }
    }

    protected void toggleAutocast(BuildingPlacement placement) {
        if (!placement.level.m_5776_()) {
            return;
        }
        if (this.isAutocasting(placement) && this.autocastDisableAction != null) {
            UnitClientEvents.sendUnitCommand(this.autocastDisableAction);
        } else if (!this.isAutocasting(placement) && this.autocastEnableAction != null) {
            UnitClientEvents.sendUnitCommand(this.autocastEnableAction);
        }
    }

    public boolean isCasting(Unit unit) {
        return false;
    }

    public float getCooldown(Unit unit) {
        return unit.getCooldown(this);
    }

    public float getCooldown(BuildingPlacement placement) {
        return placement.getCooldown(this);
    }

    public boolean isOffCooldown(Unit unit) {
        return this.getCooldown(unit) <= 0.0f || this.usesCharges() && this.getCharges(unit) > 0;
    }

    public boolean isOffCooldown(BuildingPlacement placement) {
        return this.getCooldown(placement) <= 0.0f || this.usesCharges() && this.getCharges(placement) > 0;
    }

    public void setToMaxCooldown(Unit unit) {
        unit.setCooldown(this, this.cooldownMax);
        if (this.usesCharges() && unit.getCharges(this) > 0) {
            unit.setCharges(this, unit.getCharges(this) - 1);
        }
    }

    public void setToMaxCooldown(BuildingPlacement building) {
        building.setCooldown(this, this.cooldownMax);
        if (this.usesCharges() && building.getCharges(this) > 0) {
            building.setCharges(this, building.getCharges(this) - 1);
        }
    }

    public void setCooldown(float cooldown, Unit unit) {
        this.setCooldown(cooldown, true, unit);
    }

    public void setCooldown(float cooldown, boolean useCharge, Unit unit) {
        if (((Entity)unit).m_9236_().m_5776_() && cooldown > 0.0f) {
            HudClientEvents.setLowestCdHudEntity();
        }
        unit.setCooldown(this, Math.min(cooldown, this.cooldownMax));
        if (useCharge && this.usesCharges() && unit.getCharges(this) > 0) {
            unit.setCharges(this, unit.getCharges(this) - 1);
        }
    }

    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
    }

    public void use(Level level, BuildingPlacement buildingUsing, LivingEntity targetEntity) {
    }

    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
    }

    public void use(Level level, BuildingPlacement buildingUsing, BlockPos targetBp) {
    }

    public AbilityButton getButton(BuildingPlacement placement) {
        return this.getButton(this.defaultHotkey, placement);
    }

    public AbilityButton getButton(Unit unit) {
        return this.getButton(this.defaultHotkey, unit);
    }

    public AbilityButton getButton(Keybinding hotkey, BuildingPlacement placement) {
        return null;
    }

    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        return null;
    }

    public boolean canBypassCooldown(Unit unit) {
        return this.usesCharges() && this.getCharges(unit) > 0;
    }

    public boolean canBypassCooldown(BuildingPlacement buildingPlacement) {
        return this.usesCharges() && this.getCharges(buildingPlacement) > 0;
    }

    public boolean shouldResetBehaviours() {
        return true;
    }

    protected void setDefaultAutocast(boolean b) {
        this.defaultAutocast = b;
    }

    public boolean isDefaultAutocast() {
        return this.defaultAutocast;
    }

    public int getCharges(Unit unit) {
        return unit.getCharges(this);
    }

    public int getCharges(BuildingPlacement placement) {
        return placement.getCharges(this);
    }

    public void setCharges(Unit unit, int charges) {
        unit.setCharges(this, charges);
    }
}

