/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityServerboundPacket;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class HeroAbility
extends Ability {
    public final int maxRank;
    public int manaCost = 0;

    public HeroAbility(int maxRank, UnitAction action, int cooldownMax, float range, float radius, boolean canTargetEntities) {
        super(action, cooldownMax, range, radius, canTargetEntities);
        this.maxRank = maxRank;
        this.manaCost = 0;
    }

    public HeroAbility(int maxRank, int manaCost, UnitAction action, int cooldownMax, float range, float radius, boolean canTargetEntities) {
        super(action, cooldownMax, range, radius, canTargetEntities);
        this.maxRank = maxRank;
        this.manaCost = manaCost;
    }

    public int getLevelRequirement(HeroUnit hero) {
        if (this.maxRank <= 1) {
            return 6;
        }
        return this.getRank(hero) * 2 + 1;
    }

    public boolean rankUp(HeroUnit hero) {
        if (this.getRank(hero) < this.maxRank && hero.getSkillPoints() > 0 && hero.getHeroLevel() >= this.getLevelRequirement(hero)) {
            this.setRank(hero, this.getRank(hero) + 1);
            hero.setSkillPoints(hero.getSkillPoints() - 1);
            if (((LivingEntity)hero).m_9236_().f_46443_) {
                hero.updateAbilityButtons();
            } else {
                hero.syncToClients();
            }
            return true;
        }
        return false;
    }

    public void updateStatsForRank(HeroUnit heroUnit) {
    }

    protected String rankString(HeroUnit hero) {
        return this.getRank(hero) > 0 ? I18n.m_118938_((String)"abilities.reignofnether.rank", (Object[])new Object[]{this.getRank(hero)}) : I18n.m_118938_((String)"abilities.reignofnether.unlearnt", (Object[])new Object[0]);
    }

    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of();
    }

    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of();
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit hero) {
        return null;
    }

    public Button getRankUpButton(HeroUnit hero) {
        return null;
    }

    protected Button getRankUpButtonProtected(String name, ResourceLocation resourceLocation, HeroUnit hero) {
        Button button = new Button(name, 14, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/corner_plus.png"), (Keybinding)null, () -> false, () -> !hero.isRankUpMenuOpen() || this.getRank(hero) >= this.maxRank, () -> hero.getSkillPoints() > 0 && hero.getHeroLevel() >= this.getLevelRequirement(hero), () -> {
            if (this.rankUp(hero)) {
                AbilityServerboundPacket.rankUpAbility(((Entity)hero).m_19879_(), this.action);
                hero.updateAbilityButtons();
            }
            if (hero.getSkillPoints() <= 0) {
                hero.showRankUpMenu(false);
            }
        }, null, this.getRankUpTooltipLines(hero));
        button.bgIconResource = resourceLocation;
        return button;
    }

    public static boolean allSkillsLearnt(HeroUnit hero) {
        if (hero.getHeroLevel() >= 10 && hero.getSkillPoints() <= 0) {
            return true;
        }
        int totalSkillRanks = 0;
        for (HeroAbility ability : hero.getHeroAbilities()) {
            totalSkillRanks += ability.getRank(hero);
        }
        return totalSkillRanks >= 10;
    }

    public static Button getRankUpMenuButton(HeroUnit hero) {
        Button menuButton = new Button("Rank up abilities", 14, hero.isRankUpMenuOpen() ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/tick.png"), Keybindings.keyU, () -> false, () -> HeroAbility.allSkillsLearnt(hero) || !PlayerClientEvents.isRTSPlayer(), () -> true, () -> hero.showRankUpMenu(!hero.isRankUpMenuOpen()), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.rank_up_menu", (Object[])new Object[]{hero.getSkillPoints()}), true)));
        menuButton.isFlashing = () -> !hero.isRankUpMenuOpen() && hero.getSkillPoints() > 0;
        return menuButton;
    }

    public Style getLevelReqStyle(HeroUnit hero) {
        return Style.f_131099_.m_178520_(hero.getHeroLevel() >= this.getLevelRequirement(hero) ? 65280 : 0xFF0000);
    }

    public int getRank(HeroUnit hero) {
        return hero.getHeroAbilityRank(this);
    }

    public void setRank(HeroUnit hero, int rank) {
        hero.setHeroAbilityRank(this, rank);
    }
}

