/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;

public class DisconnectPortal
extends Ability {
    private static final int CD_MAX = 0;
    private static final int RANGE = 0;

    public DisconnectPortal() {
        super(UnitAction.DISCONNECT_PORTAL, 0, 0.0f, 0.0f, true);
        this.defaultHotkey = Keybindings.keyE;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, BuildingPlacement placement) {
        if (!(placement instanceof PortalPlacement)) {
            return null;
        }
        PortalPlacement portal = (PortalPlacement)placement;
        return new AbilityButton("Sever Connection", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/barrier.png"), hotkey, () -> false, () -> {
            if (portal.getPortalType() != PortalPlacement.PortalType.TRANSPORT) {
                return true;
            }
            return !portal.hasDestination();
        }, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.DISCONNECT_PORTAL), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.disconnect_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true)))), (Ability)this, placement);
    }

    @Override
    public void use(Level level, BuildingPlacement building, BlockPos targetBp) {
        if (building instanceof PortalPlacement) {
            PortalPlacement portalPlacement = (PortalPlacement)building;
            portalPlacement.disconnectPortal();
        }
    }
}

