/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class SpiderClimbing
extends Ability {
    public SpiderClimbing() {
        super(UnitAction.NONE, 0, 0.0f, 0.0f, false, false);
        this.autocastEnableAction = UnitAction.ENABLE_SPIDER_CLIMBING;
        this.autocastDisableAction = UnitAction.DISABLE_SPIDER_CLIMBING;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        SpiderUnit spiderUnit = (SpiderUnit)unit;
        ResourceLocation rlLadder = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/ladder.png");
        ResourceLocation rlBarrier = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/barrier.png");
        AbilityButton ab = new AbilityButton("Toggle Wall Climbing", spiderUnit.isWallClimbing() ? rlLadder : rlBarrier, hotkey, () -> false, () -> false, () -> true, () -> this.toggleAutocast(unit), null, List.of(spiderUnit.isWallClimbing() ? MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.spider_climbing_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.spider_climbing_off", (Object[])new Object[0]))), (Ability)this, unit);
        if (!spiderUnit.isWallClimbing()) {
            ab.bgIconResource = rlLadder;
        }
        return ab;
    }

    @Override
    public void setAutocast(boolean value, Unit unit) {
        if (!(unit instanceof SpiderUnit)) {
            return;
        }
        SpiderUnit spiderUnit = (SpiderUnit)unit;
        super.setAutocast(value, unit);
        if (this.isAutocasting(unit) && !spiderUnit.isWallClimbing() || !this.isAutocasting(unit) && spiderUnit.isWallClimbing()) {
            spiderUnit.toggleWallClimbing();
        }
        spiderUnit.updateAbilityButtons();
    }

    @Override
    public boolean shouldResetBehaviours() {
        return false;
    }
}

