/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.monster;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class InsomniaCurse
extends HeroAbility {
    public static final int RANGE = 12;
    public static final float PHANTOM_DAMAGE = 6.0f;
    public static final float PHANTOM_DAMAGE_BONUS_PER_SOUL_RANK = 2.0f;
    public static final int PHANTOM_MAX_ATTACKS = 6;

    public InsomniaCurse() {
        super(3, 15, UnitAction.INSOMNIA_CURSE, 400, 12.0f, 0.0f, true);
        this.maxCharges = 3;
    }

    @Override
    public boolean rankUp(HeroUnit hero) {
        if (super.rankUp(hero)) {
            this.updateStatsForRank(hero);
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank(HeroUnit hero) {
        if (this.getRank(hero) == 1) {
            this.maxCharges = 3;
            this.cooldownMax = 400.0f;
        } else if (this.getRank(hero) == 2) {
            this.maxCharges = 4;
            this.maxCharges = 4;
            this.cooldownMax = 340.0f;
        } else if (this.getRank(hero) == 3) {
            this.maxCharges = 5;
            this.cooldownMax = 280.0f;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Curse of Insomnia", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/phantom.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.INSOMNIA_CURSE, () -> this.getRank(hero) == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.INSOMNIA_CURSE), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Curse of Insomnia", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/phantom.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.stats", (Object[])new Object[]{Float.valueOf(6.0f), Float.valueOf(this.cooldownMax / 20.0f), 12, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.tooltip2", (Object[])new Object[]{Float.valueOf(6.0f), Float.valueOf(2.0f)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.tooltip3", (Object[])new Object[]{6})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.charges", (Object[])new Object[]{this.maxCharges})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.tooltip2", (Object[])new Object[]{Float.valueOf(6.0f), Float.valueOf(2.0f)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.tooltip3", (Object[])new Object[]{6})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.insomnia_curse.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        if (targetEntity == unitUsing) {
            return;
        }
        ((NecromancerUnit)unitUsing).getCastPhantomGoal().setAbility(this);
        ((NecromancerUnit)unitUsing).getCastPhantomGoal().setTarget(targetEntity);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        if (BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), targetBp)) {
            ((NecromancerUnit)unitUsing).getCastPhantomGoal().setAbility(this);
            ((NecromancerUnit)unitUsing).getCastPhantomGoal().setTarget(targetBp);
        }
    }
}

