/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FancyFeast
extends HeroAbility {
    public static final int RANGE = 10;
    private static final int CD_MAX_SECONDS = 900;
    public static final int BASE_ITEMS = 6;
    public static final int BONUS_ITEMS_PER_100_RESOURCES = 2;
    private static final float HEALTH_PER_BREAD = 10.0f;
    private static final float HEALTH_PER_CHICKEN = 15.0f;
    private static final float HEALTH_PER_BEEF = 20.0f;

    public FancyFeast() {
        super(3, 70, UnitAction.FANCY_FEAST, 900, 10.0f, 0.0f, false);
    }

    private ResourceLocation getIcon(int plusRank, HeroUnit hero) {
        if (this.getRank(hero) + plusRank == 3) {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/cooked_beef.png");
        }
        if (this.getRank(hero) + plusRank == 2) {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/cooked_chicken.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/bread.png");
    }

    public Item getFoodItem(HeroUnit hero) {
        if (this.getRank(hero) == 3) {
            return Items.f_42580_;
        }
        if (this.getRank(hero) == 2) {
            return Items.f_42582_;
        }
        return Items.f_42406_;
    }

    private float getHealAmount(HeroUnit hero) {
        if (this.getRank(hero) == 3) {
            return 20.0f;
        }
        if (this.getRank(hero) == 2) {
            return 15.0f;
        }
        return 10.0f;
    }

    @Override
    public boolean isCasting(Unit unit) {
        PiglinMerchantUnit piglinMerchantUnit;
        GenericTargetedSpellGoal goal;
        if (unit instanceof PiglinMerchantUnit && (goal = (piglinMerchantUnit = (PiglinMerchantUnit)unit).getCastFancyFeastGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Fancy Feast", this.getIcon(0, hero), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.FANCY_FEAST, () -> this.getRank(hero) == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.FANCY_FEAST), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Fancy Feast", this.getIcon(1, hero), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.stats", (Object[])new Object[]{Float.valueOf(this.getHealAmount(hero)), 45, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip2", (Object[])new Object[]{6, 2})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip2", (Object[])new Object[]{6, 2})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setTarget(targetBp);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setTarget(targetEntity.m_20097_());
    }
}

