/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class GreedIsGoodPassive
extends HeroAbility {
    public int maxResourcesPerCast = 100;

    public GreedIsGoodPassive() {
        super(3, 0, UnitAction.NONE, 0, 0.0f, 0.0f, false);
        this.autocastEnableAction = UnitAction.ENABLE_GREED_IS_GOOD_PASSIVE;
        this.autocastDisableAction = UnitAction.DISABLE_GREED_IS_GOOD_PASSIVE;
        this.setDefaultAutocast(true);
    }

    @Override
    public boolean rankUp(HeroUnit hero) {
        if (super.rankUp(hero)) {
            this.updateStatsForRank(hero);
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank(HeroUnit hero) {
        if (this.getRank(hero) == 1) {
            this.maxResourcesPerCast = 100;
        } else if (this.getRank(hero) == 2) {
            this.maxResourcesPerCast = 200;
        } else if (this.getRank(hero) == 3) {
            this.maxResourcesPerCast = 300;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Greed is Good", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/gold_block.png"), hotkey, () -> this.isAutocasting(hero), () -> this.getRank(hero) == 0, () -> true, () -> this.toggleAutocast(hero), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Greed is Good", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/gold_block.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip2", (Object[])new Object[]{this.maxResourcesPerCast})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip3", (Object[])new Object[0])));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip2", (Object[])new Object[]{this.maxResourcesPerCast})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.can_be_toggled", (Object[])new Object[0])), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }

    public int spendResourcesAndGet100sSpent(ResourceName resName, HeroUnit hero) {
        ArrayList<Resources> resourcesList;
        int totalSpent = 0;
        String ownerName = hero.getOwnerName();
        boolean isClientSide = ((LivingEntity)hero).m_9236_().m_5776_();
        ArrayList<Resources> arrayList = resourcesList = isClientSide ? ResourcesClientEvents.resourcesList : ResourcesServerEvents.resourcesList;
        if (this.isAutocasting(hero)) {
            for (Resources resources : resourcesList) {
                if (!resources.ownerName.equals(ownerName)) continue;
                for (int i = 0; i < this.getRank(hero); ++i) {
                    Resources resToSpend = new Resources(hero.getOwnerName(), 0, 0, 0);
                    if (resName == ResourceName.FOOD && resources.food >= 100) {
                        resToSpend.food -= 100;
                        totalSpent += 100;
                    } else if (resName == ResourceName.WOOD && resources.wood >= 100) {
                        resToSpend.wood -= 100;
                        totalSpent += 100;
                    } else if (resName == ResourceName.ORE && resources.ore >= 100) {
                        resToSpend.ore -= 100;
                        totalSpent += 100;
                    }
                    if (isClientSide) continue;
                    ResourcesServerEvents.addSubtractResources(resToSpend);
                }
            }
        }
        return totalSpent / 100;
    }
}

