/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class LootExplosion
extends HeroAbility {
    private static final int CD_MAX_SECONDS = 6000;
    public static final int BASE_ITEMS = 12;
    public static final int BONUS_ITEMS_PER_100_RESOURCES = 3;

    public LootExplosion() {
        super(1, 125, UnitAction.LOOT_EXPLOSION, 6000, 0.0f, 0.0f, false);
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Loot Explosion", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/iron_chestplate.png"), hotkey, () -> false, () -> this.getRank(hero) == 0, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.LOOT_EXPLOSION), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public boolean isCasting(Unit unit) {
        PiglinMerchantUnit piglinMerchantUnit;
        GenericUntargetedSpellGoal goal;
        if (unit instanceof PiglinMerchantUnit && (goal = (piglinMerchantUnit = (PiglinMerchantUnit)unit).getCastLootExplosionGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Loot Explosion", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/iron_chestplate.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.stats", (Object[])new Object[]{300, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.tooltip3", (Object[])new Object[]{12, 3})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.loot_explosion.tooltip3", (Object[])new Object[]{12, 3})));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((PiglinMerchantUnit)unitUsing).getCastLootExplosionGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastLootExplosionGoal().startCasting();
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((PiglinMerchantUnit)unitUsing).getCastLootExplosionGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastLootExplosionGoal().startCasting();
    }
}

