/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.FortressPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Fortress
extends ProductionBuilding {
    public static final String buildingName = "Fortress";
    public static final String structureName = "fortress";
    public static final ResourceCost cost = ResourceCosts.FORTRESS;

    public Fortress() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50712_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/chiseled_nether_bricks.png");
        this.buildTimeModifier = 0.5f;
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50134_);
        this.startingBlockTypes.add(Blocks.f_50197_);
        this.startingBlockTypes.add(Blocks.f_50138_);
        this.startingBlockTypes.add(Blocks.f_50199_);
        this.productions.add(ProductionItems.RESEARCH_ADVANCED_PORTALS, Keybindings.keyQ);
        this.productions.add(ProductionItems.RESEARCH_BLOODLUST, Keybindings.keyW);
        this.productions.add(ProductionItems.RESEARCH_SOUL_FIREBALLS, Keybindings.keyE);
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new FortressPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false);
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/chiseled_nether_bricks.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.FORTRESS, () -> false, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.FLAME_SANCTUARY) && BuildingClientEvents.hasFinishedBuilding(Buildings.WITHER_SHRINE) || ResearchClient.hasCheat("modifythephasevariance"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress.tooltip2", (Object[])new Object[]{7}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }
}

