/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.gamemode;

import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.startpos.StartPosServerboundPacket;
import com.solegendary.reignofnether.util.Faction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class GameModeClientboundPacket {
    public GameMode gameMode;

    public static void setAndLockAllClientGameModes(GameMode mode) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameModeClientboundPacket(mode));
    }

    public GameModeClientboundPacket(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public GameModeClientboundPacket(FriendlyByteBuf buffer) {
        this.gameMode = (GameMode)buffer.m_130066_(GameMode.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.gameMode);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.gameMode != GameMode.NONE) {
                ClientGameModeHelper.gameModeLocked = true;
                ClientGameModeHelper.gameMode = this.gameMode;
                if (this.gameMode != GameMode.CLASSIC && StartPosClientEvents.hasReservedPos()) {
                    StartPosClientEvents.selectedFaction = Faction.NONE;
                    StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
                }
            } else {
                ClientGameModeHelper.gameModeLocked = false;
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

