/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hero;

import com.solegendary.reignofnether.hero.HeroAction;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class HeroServerboundPacket {
    private final int unitId;
    private final HeroAction heroAction;

    public static void requestHeroSync(int unitId) {
        PacketHandler.INSTANCE.sendToServer((Object)new HeroServerboundPacket(unitId, HeroAction.REQUEST_SYNC));
    }

    public HeroServerboundPacket(int unitId, HeroAction heroAction) {
        this.unitId = unitId;
        this.heroAction = heroAction;
    }

    public HeroServerboundPacket(FriendlyByteBuf buffer) {
        this.unitId = buffer.readInt();
        this.heroAction = (HeroAction)buffer.m_130066_(HeroAction.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.unitId);
        buffer.m_130068_((Enum)this.heroAction);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            if (this.heroAction == HeroAction.REQUEST_SYNC) {
                for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                    if (entity.m_19879_() != this.unitId || !(entity instanceof HeroUnit)) continue;
                    HeroUnit hero = (HeroUnit)entity;
                    hero.syncToClients();
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

