/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.solegendary.reignofnether.mixin.SplashRendererAccessor;
import com.solegendary.reignofnether.util.Faction;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TitleClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Random random = new Random();
    private static Faction titleBackgroundFaction = TitleClientEvents.getRandomFaction();
    private static PanoramaRenderer panorama = new PanoramaRenderer(TitleClientEvents.getCubeMap());
    public static String splash = TitleClientEvents.getRandomSplash();

    public static PanoramaRenderer getPanorama() {
        return panorama;
    }

    private static CubeMap getCubeMap() {
        String dir = "";
        switch (titleBackgroundFaction) {
            case VILLAGERS: {
                dir = "villagers";
                break;
            }
            case MONSTERS: {
                dir = "monsters";
                break;
            }
            case PIGLINS: {
                dir = "piglins";
            }
        }
        return new CubeMap(ResourceLocation.parse((String)("textures/gui/title/background/" + dir + "/panorama")));
    }

    private static Faction getRandomFaction() {
        Faction result = Faction.VILLAGERS;
        switch (random.nextInt(3)) {
            case 1: {
                result = Faction.MONSTERS;
                break;
            }
            case 2: {
                result = Faction.PIGLINS;
            }
        }
        return result;
    }

    private static Faction getNewRandomFaction() {
        Faction result = Faction.VILLAGERS;
        switch (titleBackgroundFaction) {
            case VILLAGERS: {
                result = random.nextBoolean() ? Faction.MONSTERS : Faction.PIGLINS;
                break;
            }
            case MONSTERS: {
                result = random.nextBoolean() ? Faction.VILLAGERS : Faction.PIGLINS;
                break;
            }
            case PIGLINS: {
                result = random.nextBoolean() ? Faction.VILLAGERS : Faction.MONSTERS;
            }
        }
        return result;
    }

    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening evt) {
        if (evt.getScreen() instanceof TitleScreen) {
            titleBackgroundFaction = TitleClientEvents.getNewRandomFaction();
            panorama = new PanoramaRenderer(TitleClientEvents.getCubeMap());
        }
    }

    private static String getRandomSplash() {
        return ((SplashRendererAccessor)MC.m_91310_().m_280369_()).getSplash();
    }

    @SubscribeEvent
    public static void onKeyPress(ScreenEvent.KeyPressed.Pre evt) {
        if (evt.getKeyCode() == 32) {
            splash = TitleClientEvents.getRandomSplash();
        }
    }
}

