/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud.playerdisplay;

import com.solegendary.reignofnether.alliance.AllianceAction;
import com.solegendary.reignofnether.alliance.AllianceServerboundPacket;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.hud.playerdisplay.DiplomacyPlayerDisplay;
import com.solegendary.reignofnether.hud.playerdisplay.ObserverPlayerDisplay;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDisplayClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static ArrayList<ObserverPlayerDisplay> observerPlayerDisplays = new ArrayList();
    private static ArrayList<DiplomacyPlayerDisplay> rtsDiplomacyPlayerDisplays = new ArrayList();
    private static ArrayList<DiplomacyPlayerDisplay> fpvDiplomacyPlayerDisplays = new ArrayList();
    private static final ArrayList<Button> renderedButtons = new ArrayList();
    private static final ArrayList<RectZone> hudZones = new ArrayList();
    private static DisplayType displayType = DisplayType.NONE;
    private static final int BG_BORDER_WIDTH = 7;
    public static final Button observerButton = new Button("Toggle Observer Displays", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/observer.png"), Keybindings.keyZ, () -> displayType == DisplayType.OBSERVER, () -> PlayerClientEvents.isRTSPlayer() || PlayerClientEvents.rtsPlayers.isEmpty(), () -> true, () -> {
        displayType = displayType != DisplayType.NONE ? DisplayType.NONE : DisplayType.OBSERVER;
    }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.toggle_observer_player_displays", (Object[])new Object[0]), (Style)Style.f_131099_)));
    public static final Button diplomacyButton = new Button("Toggle Diplomacy Displays", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/sweet_berries.png"), Keybindings.keyZ, () -> displayType == DisplayType.DIPLOMACY, () -> !PlayerClientEvents.isRTSPlayer() || PlayerClientEvents.rtsPlayers.size() + PlayerDisplayClientEvents.getNumFpvPlayers() <= 1, () -> true, () -> {
        displayType = displayType != DisplayType.NONE ? DisplayType.NONE : DisplayType.DIPLOMACY;
    }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.toggle_diplomacy_player_displays", (Object[])new Object[0]), (Style)Style.f_131099_)));
    public static final Button shareUnitControlButton = new Button("Toggle Share Unit Control", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/chain_command_block_back.png"), (Keybinding)null, AlliancesClient::sharingAllyControl, () -> !PlayerClientEvents.isRTSPlayer() || PlayerClientEvents.rtsPlayers.size() <= 1, () -> true, () -> AllianceServerboundPacket.doAllianceAction(AllianceAction.SET_ALLY_CONTROL, !AlliancesClient.sharingAllyControl()), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.toggle_shared_unit_control", (Object[])new Object[0]), (Style)Style.f_131099_)));

    public static void resetDisplay() {
        displayType = DisplayType.NONE;
    }

    private static int getNumFpvPlayers() {
        if (PlayerDisplayClientEvents.MC.f_91073_ == null) {
            return 0;
        }
        return PlayerDisplayClientEvents.MC.f_91073_.m_6907_().stream().filter(p -> !p.m_5833_() && !p.m_7500_()).toList().size();
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render.Post evt) {
        if (!OrthoviewClientEvents.isEnabled() || !(evt.getScreen() instanceof TopdownGui) || PlayerDisplayClientEvents.MC.f_91073_ == null) {
            return;
        }
        renderedButtons.clear();
        hudZones.clear();
        if (displayType == DisplayType.DIPLOMACY) {
            PlayerDisplayClientEvents.renderDiplomacyPlayerDisplays(evt);
        } else if (displayType == DisplayType.OBSERVER) {
            PlayerDisplayClientEvents.renderObserverPlayerDisplays(evt);
        }
        for (Button button : renderedButtons) {
            if (!button.isMouseOver(evt.getMouseX(), evt.getMouseY())) continue;
            button.renderTooltip(evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY());
        }
    }

    @SubscribeEvent
    public static void onMousePress(ScreenEvent.MouseButtonPressed.Post evt) {
        for (Button button : renderedButtons) {
            if (evt.getButton() == 0) {
                button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), true);
                continue;
            }
            if (evt.getButton() != 1) continue;
            button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), false);
        }
    }

    @SubscribeEvent
    public static void onKeyRelease(ScreenEvent.KeyReleased.Post evt) {
        if (PlayerDisplayClientEvents.MC.f_91080_ == null || !PlayerDisplayClientEvents.MC.f_91080_.m_96636_().getString().contains("topdowngui_container")) {
            return;
        }
        for (Button button : renderedButtons) {
            button.checkPressed(evt.getKeyCode());
        }
    }

    private static void renderObserverPlayerDisplays(ScreenEvent.Render.Post evt) {
        int screenWidth = MC.m_91268_().m_85445_();
        int blitX = screenWidth / 2 - ObserverPlayerDisplay.DISPLAY_WIDTH / 2 + 10;
        int blitY = 70;
        GuiGraphics guiGraphics = evt.getGuiGraphics();
        observerPlayerDisplays.removeIf(r -> !PlayerClientEvents.rtsPlayers.stream().map(rtsp -> rtsp.name).toList().contains(r.playerName));
        List trackedPlayers = observerPlayerDisplays.stream().map(d -> d.playerName).collect(Collectors.toCollection(ArrayList::new));
        for (RTSPlayer rtsPlayer : PlayerClientEvents.rtsPlayers) {
            if (trackedPlayers.contains(rtsPlayer.name)) continue;
            observerPlayerDisplays.add(new ObserverPlayerDisplay(rtsPlayer));
        }
        guiGraphics.m_280509_(blitX - 7, blitY - 7, blitX + ObserverPlayerDisplay.DISPLAY_WIDTH + 7, (blitY + Button.DEFAULT_ICON_FRAME_SIZE + 7) * observerPlayerDisplays.size(), -1728053248);
        for (ObserverPlayerDisplay playerDisplay : observerPlayerDisplays) {
            hudZones.add(playerDisplay.getRectZone(blitX, blitY, 7));
            playerDisplay.render(guiGraphics, blitX, blitY);
            blitY += Button.DEFAULT_ICON_FRAME_SIZE;
        }
    }

    private static void renderDiplomacyPlayerDisplays(ScreenEvent.Render.Post evt) {
        if (PlayerDisplayClientEvents.MC.f_91073_ == null || PlayerDisplayClientEvents.MC.f_91074_ == null) {
            return;
        }
        int screenWidth = MC.m_91268_().m_85445_();
        int blitX = screenWidth / 2 - DiplomacyPlayerDisplay.DISPLAY_WIDTH / 2 + 10;
        int blitY = 37;
        GuiGraphics guiGraphics = evt.getGuiGraphics();
        rtsDiplomacyPlayerDisplays.removeIf(d -> !PlayerClientEvents.rtsPlayers.stream().map(rtsp -> rtsp.name).toList().contains(d.playerName));
        fpvDiplomacyPlayerDisplays.removeIf(d -> !PlayerDisplayClientEvents.MC.f_91073_.m_6907_().stream().map(p -> p.m_7755_().getString()).toList().contains(d.playerName));
        Set trackedRtsPlayers = rtsDiplomacyPlayerDisplays.stream().map(d -> d.playerName).collect(Collectors.toSet());
        Set trackedFpvPlayers = fpvDiplomacyPlayerDisplays.stream().map(d -> d.playerName).collect(Collectors.toSet());
        for (AbstractClientPlayer player : PlayerDisplayClientEvents.MC.f_91073_.m_6907_()) {
            RTSPlayer rtsPlayer;
            if (player == PlayerDisplayClientEvents.MC.f_91074_ || (rtsPlayer = PlayerClientEvents.getRTSPlayer(player.m_7755_().getString())) != null || trackedFpvPlayers.contains(player.m_7755_().getString()) || player.m_5833_() || player.m_7500_()) continue;
            fpvDiplomacyPlayerDisplays.add(new DiplomacyPlayerDisplay(player));
            rtsDiplomacyPlayerDisplays.removeIf(d -> d.playerName.equals(player.m_7755_().getString()));
        }
        for (RTSPlayer rtsPlayer : PlayerClientEvents.rtsPlayers) {
            if (rtsPlayer.name.equals(PlayerDisplayClientEvents.MC.f_91074_.m_7755_().getString()) || trackedRtsPlayers.contains(rtsPlayer.name)) continue;
            rtsDiplomacyPlayerDisplays.add(new DiplomacyPlayerDisplay(rtsPlayer));
            fpvDiplomacyPlayerDisplays.removeIf(d -> d.playerName.equals(rtsPlayer.name));
        }
        boolean canShareUnitControl = !rtsDiplomacyPlayerDisplays.isEmpty() && PlayerDisplayClientEvents.shareUnitControlButton.isHidden.get() == false;
        int x1 = blitX - 7;
        int y1 = blitY - 7;
        int x2 = blitX + DiplomacyPlayerDisplay.DISPLAY_WIDTH + 7;
        int y2 = blitY + (Button.DEFAULT_ICON_FRAME_SIZE + 7) * (rtsDiplomacyPlayerDisplays.size() + fpvDiplomacyPlayerDisplays.size()) + (canShareUnitControl ? (int)((float)Button.DEFAULT_ICON_FRAME_SIZE * 1.5f) : 0);
        guiGraphics.m_280509_(x1, y1, x2, y2, -1728053248);
        hudZones.add(new RectZone(x1, y1, x2, y2));
        if (!rtsDiplomacyPlayerDisplays.isEmpty() && !PlayerDisplayClientEvents.shareUnitControlButton.isHidden.get().booleanValue()) {
            shareUnitControlButton.render(guiGraphics, blitX, blitY, evt.getMouseX(), evt.getMouseY());
            MyRenderer.renderFrameWithBg(guiGraphics, blitX + Button.DEFAULT_ICON_FRAME_SIZE, blitY, 102 + (AlliancesClient.sharingAllyControl() ? 10 : 15), Button.DEFAULT_ICON_FRAME_SIZE, -1610612736);
            guiGraphics.m_280488_(PlayerDisplayClientEvents.MC.f_91062_, "Shared Control: " + (AlliancesClient.sharingAllyControl() ? "ON" : "OFF"), blitX + Button.DEFAULT_ICON_SIZE / 2 + 1 + Button.DEFAULT_ICON_FRAME_SIZE, blitY + Button.DEFAULT_ICON_SIZE / 2 + 1, 0xFFFFFF);
            blitY = (int)((float)blitY + (float)Button.DEFAULT_ICON_FRAME_SIZE * 1.5f);
            renderedButtons.add(shareUnitControlButton);
        }
        for (DiplomacyPlayerDisplay playerDisplay : rtsDiplomacyPlayerDisplays) {
            hudZones.add(playerDisplay.getRectZone(blitX, blitY, 7));
            renderedButtons.addAll(playerDisplay.render(guiGraphics, blitX, blitY, evt.getMouseX(), evt.getMouseY()));
            blitY += Button.DEFAULT_ICON_FRAME_SIZE;
        }
        for (DiplomacyPlayerDisplay playerDisplay : fpvDiplomacyPlayerDisplays) {
            hudZones.add(playerDisplay.getRectZone(blitX, blitY, 7));
            renderedButtons.addAll(playerDisplay.render(guiGraphics, blitX, blitY, evt.getMouseX(), evt.getMouseY()));
            blitY += Button.DEFAULT_ICON_FRAME_SIZE;
        }
    }

    public static boolean isMouseOverHud(int mouseX, int mouseY) {
        for (RectZone hudZone : hudZones) {
            if (!hudZone.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    private static enum DisplayType {
        OBSERVER,
        DIPLOMACY,
        NONE;

    }
}

