/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin;

import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.MyMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderChunkRegion.class})
public abstract class RenderChunkRegionMixin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBlockState(BlockPos pPos, CallbackInfoReturnable<BlockState> cir) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && OrthoviewClientEvents.shouldHideLeaves()) {
            Block block = level.m_8055_(pPos).m_60734_();
            Block blockBelow = level.m_8055_(pPos.m_7495_()).m_60734_();
            BlockState replacementBs = null;
            if (block == BlockRegistrar.DECAYABLE_NETHER_WART_BLOCK.get()) {
                replacementBs = Blocks.f_50214_.m_49966_();
            } else if (block instanceof LeavesBlock) {
                replacementBs = Blocks.f_50213_.m_49966_();
            } else if (block instanceof SnowLayerBlock && blockBelow instanceof LeavesBlock) {
                replacementBs = Blocks.f_50016_.m_49966_();
            }
            if (replacementBs != null) {
                if (OrthoviewClientEvents.hideLeavesMethod == OrthoviewClientEvents.LeafHideMethod.ALL) {
                    cir.setReturnValue((Object)replacementBs);
                    return;
                }
                List<ArrayList<Vec3>> list = UnitClientEvents.unitWindowVecs;
                synchronized (list) {
                    for (ArrayList<Vec3> vecs : UnitClientEvents.unitWindowVecs) {
                        if (!MyMath.isPointInsideRect3d(vecs, Vec3.m_82512_((Vec3i)pPos))) continue;
                        cir.setReturnValue((Object)replacementBs);
                        return;
                    }
                }
            }
        }
    }
}

