/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.nether;

import com.solegendary.reignofnether.registrars.BlockRegistrar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class NetherBlocks {
    private static final Random random = new Random();
    public static final List<Block> FLOWERS = List.of(Blocks.f_50111_, Blocks.f_50121_, Blocks.f_50113_, Blocks.f_50112_, Blocks.f_50358_, Blocks.f_50356_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50120_, Blocks.f_50071_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50116_, Blocks.f_50119_);
    public static final Map<Block, List<Block>> MAPPINGS = new HashMap<Block, List<Block>>();
    public static final Map<Block, List<Block>> PLANT_MAPPINGS = new HashMap<Block, List<Block>>();

    public static BlockState getNetherBlock(Level level, BlockPos overworldBp) {
        BlockState overworldBs = level.m_8055_(overworldBp);
        if (!overworldBs.m_60795_()) {
            for (Map.Entry<Block, List<Block>> entrySet : MAPPINGS.entrySet()) {
                for (Block block : entrySet.getValue()) {
                    if (!overworldBs.m_60734_().equals(block)) continue;
                    return entrySet.getKey().m_49966_();
                }
            }
        }
        return null;
    }

    public static BlockState getNetherPlantBlock(Level level, BlockPos overworldBp) {
        BlockState overworldBs = level.m_8055_(overworldBp);
        if (!overworldBs.m_60795_()) {
            for (Map.Entry<Block, List<Block>> entrySet : PLANT_MAPPINGS.entrySet()) {
                for (Block block : entrySet.getValue()) {
                    if (!overworldBs.m_60734_().equals(block)) continue;
                    BlockState bs = entrySet.getKey().m_49966_();
                    if (bs.m_60734_() instanceof NetherWartBlock) {
                        return (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(3));
                    }
                    return bs;
                }
            }
        }
        return null;
    }

    public static boolean isNetherBlock(Level level, BlockPos bp) {
        TranslatableContents contents;
        BlockState bs = level.m_8055_(bp);
        ComponentContents componentContents = bs.m_60734_().m_49954_().m_214077_();
        if (componentContents instanceof TranslatableContents && ((contents = (TranslatableContents)componentContents).m_237508_().contains("blackstone") || contents.m_237508_().contains("nether_brick"))) {
            return true;
        }
        for (Map.Entry<Block, List<Block>> entrySet : MAPPINGS.entrySet()) {
            if (bs.m_60795_() || !bs.m_60734_().equals(entrySet.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNetherPlantBlock(Level level, BlockPos bp) {
        BlockState bs = level.m_8055_(bp);
        for (Map.Entry<Block, List<Block>> entrySet : PLANT_MAPPINGS.entrySet()) {
            if (bs.m_60795_() || !bs.m_60734_().equals(entrySet.getKey())) continue;
            return true;
        }
        return false;
    }

    public static BlockState getOverworldBlock(Level level, BlockPos overworldBp) {
        try {
            BlockState netherBs = level.m_8055_(overworldBp);
            if (!netherBs.m_60795_()) {
                for (Map.Entry<Block, List<Block>> entrySet : MAPPINGS.entrySet()) {
                    if (netherBs.m_60734_() == Blocks.f_50080_) {
                        return Blocks.f_49990_.m_49966_();
                    }
                    if (netherBs.m_60734_() == Blocks.f_50134_) {
                        return Blocks.f_50493_.m_49966_();
                    }
                    if (!entrySet.getKey().m_49954_().getString().equals(netherBs.m_60734_().m_49954_().getString())) continue;
                    return entrySet.getValue().get(0).m_49966_();
                }
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    public static BlockState getOverworldPlantBlock(Level level, BlockPos overworldBp, boolean randomisePlant) {
        BlockState netherBs = level.m_8055_(overworldBp);
        if (!netherBs.m_60795_()) {
            for (Map.Entry<Block, List<Block>> entrySet : PLANT_MAPPINGS.entrySet()) {
                if (!entrySet.getKey().m_49954_().getString().equals(netherBs.m_60734_().m_49954_().getString())) continue;
                if (randomisePlant) {
                    return NetherBlocks.getRandomPlantForBiome(level, overworldBp).m_49966_();
                }
                return entrySet.getValue().get(0).m_49966_();
            }
        }
        return null;
    }

    private static Block getRandomPlantForBiome(Level level, BlockPos overworldBp) {
        int randInt = random.nextInt(100);
        Biome biome = (Biome)level.m_204166_(overworldBp).get();
        if (biome.m_47554_() >= 2.0f && level.m_8055_(overworldBp.m_7495_()).m_60734_() == Blocks.f_49992_) {
            return Blocks.f_50036_;
        }
        if (biome.m_47554_() >= 1.0f) {
            return Blocks.f_50034_;
        }
        if (biome.m_47554_() >= 0.0f) {
            if (randInt < 10) {
                return FLOWERS.get(random.nextInt(FLOWERS.size()));
            }
            return Blocks.f_50034_;
        }
        if (randInt < 20) {
            return Blocks.f_50035_;
        }
        return Blocks.f_50034_;
    }

    static {
        MAPPINGS.put(Blocks.f_152477_, List.of(Blocks.f_152476_, Blocks.f_152478_));
        MAPPINGS.put(Blocks.f_50450_, List.of(Blocks.f_50652_));
        MAPPINGS.put((Block)BlockRegistrar.WALKABLE_MAGMA_BLOCK.get(), List.of(Blocks.f_50652_));
        MAPPINGS.put(Blocks.f_50701_, List.of(Blocks.f_50717_));
        MAPPINGS.put(Blocks.f_50136_, List.of(Blocks.f_49992_, Blocks.f_49993_));
        MAPPINGS.put(Blocks.f_50016_, List.of(Blocks.f_50125_));
        MAPPINGS.put(Blocks.f_49991_, List.of(Blocks.f_49990_, Blocks.f_50628_, Blocks.f_50080_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50575_, Blocks.f_50576_));
        MAPPINGS.put(Blocks.f_50699_, List.of(Blocks.f_50440_, Blocks.f_50493_, Blocks.f_50546_, Blocks.f_152481_, Blocks.f_152549_, Blocks.f_50599_, Blocks.f_220864_, Blocks.f_152544_, Blocks.f_50195_));
        MAPPINGS.put(Blocks.f_50134_, List.of(Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50127_, Blocks.f_152499_, Blocks.f_50352_, Blocks.f_50301_, Blocks.f_50288_, Blocks.f_50291_, Blocks.f_50299_, Blocks.f_50287_, Blocks.f_50295_, Blocks.f_50079_, Blocks.f_50377_));
        MAPPINGS.put(Blocks.f_50197_, List.of(Blocks.f_50222_, Blocks.f_50224_, Blocks.f_50223_, Blocks.f_50378_, Blocks.f_50379_));
        MAPPINGS.put(Blocks.f_50712_, List.of(Blocks.f_50225_, Blocks.f_152593_));
        MAPPINGS.put(Blocks.f_50735_, List.of(Blocks.f_152589_));
        MAPPINGS.put(Blocks.f_50736_, List.of(Blocks.f_152594_));
        MAPPINGS.put(Blocks.f_50452_, List.of(Blocks.f_50076_, Blocks.f_220844_));
        MAPPINGS.put(Blocks.f_50137_, List.of(Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152497_));
        MAPPINGS.put(Blocks.f_50730_, List.of(Blocks.f_152550_, Blocks.f_152496_));
        MAPPINGS.put(Blocks.f_50135_, List.of(Blocks.f_49994_, Blocks.f_50062_, Blocks.f_50063_, Blocks.f_50394_, Blocks.f_50395_, Blocks.f_50093_, Blocks.f_50129_));
        MAPPINGS.put(Blocks.f_50697_, List.of(Blocks.f_50011_, Blocks.f_50013_, Blocks.f_50015_, Blocks.f_50043_, Blocks.f_50014_, Blocks.f_220836_, Blocks.f_50012_));
        MAPPINGS.put(Blocks.f_50698_, List.of(Blocks.f_50044_, Blocks.f_50046_, Blocks.f_50048_, Blocks.f_50049_, Blocks.f_50047_, Blocks.f_220837_, Blocks.f_50045_));
        MAPPINGS.put(Blocks.f_50695_, List.of(Blocks.f_49999_, Blocks.f_50001_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50002_, Blocks.f_220832_, Blocks.f_50000_));
        MAPPINGS.put((Block)BlockRegistrar.FALLING_CRIMSON_STEM.get(), List.of((Block)BlockRegistrar.FALLING_OAK_LOG.get(), (Block)BlockRegistrar.FALLING_ACACIA_LOG.get(), (Block)BlockRegistrar.FALLING_BIRCH_LOG.get(), (Block)BlockRegistrar.FALLING_MANGROVE_LOG.get(), (Block)BlockRegistrar.FALLING_DARK_OAK_LOG.get(), (Block)BlockRegistrar.FALLING_JUNGLE_LOG.get(), (Block)BlockRegistrar.FALLING_SPRUCE_LOG.get()));
        MAPPINGS.put(Blocks.f_50696_, List.of(Blocks.f_50010_, Blocks.f_50006_, Blocks.f_50008_, Blocks.f_50009_, Blocks.f_50007_, Blocks.f_220835_, Blocks.f_50005_));
        MAPPINGS.put((Block)BlockRegistrar.DECAYABLE_NETHER_WART_BLOCK.get(), List.of(Blocks.f_50050_, Blocks.f_50052_, Blocks.f_50054_, Blocks.f_50055_, Blocks.f_50053_, Blocks.f_220838_, Blocks.f_50051_, Blocks.f_152470_, Blocks.f_152471_));
        MAPPINGS.put(Blocks.f_50331_, List.of(Blocks.f_49997_, Blocks.f_152469_));
        MAPPINGS.put(Blocks.f_49998_, List.of(Blocks.f_152505_, Blocks.f_152506_, Blocks.f_49996_, Blocks.f_50059_, Blocks.f_50173_, Blocks.f_152468_, Blocks.f_152472_, Blocks.f_152473_));
        MAPPINGS.put(Blocks.f_50706_, List.of(Blocks.f_49995_, Blocks.f_50264_, Blocks.f_152467_, Blocks.f_152479_));
        MAPPINGS.put(Blocks.f_50722_, List.of(Blocks.f_50089_, Blocks.f_152474_));
        PLANT_MAPPINGS.put(Blocks.f_50700_, List.of(Blocks.f_50111_, Blocks.f_50355_, Blocks.f_50121_, Blocks.f_50113_, Blocks.f_50112_, Blocks.f_50358_, Blocks.f_50356_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50120_, Blocks.f_50071_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50116_, Blocks.f_50119_));
        PLANT_MAPPINGS.put(Blocks.f_50654_, List.of(Blocks.f_50034_, Blocks.f_50359_));
        PLANT_MAPPINGS.put(Blocks.f_50703_, List.of(Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50357_, Blocks.f_50036_, Blocks.f_220833_, Blocks.f_220834_, Blocks.f_152541_, Blocks.f_152542_, Blocks.f_50130_, Blocks.f_50128_));
        PLANT_MAPPINGS.put(Blocks.f_50073_, List.of(Blocks.f_50685_));
        PLANT_MAPPINGS.put(Blocks.f_50200_, List.of(Blocks.f_50092_, Blocks.f_50249_, Blocks.f_50250_, Blocks.f_50444_, Blocks.f_50189_, Blocks.f_50190_, Blocks.f_50130_));
    }
}

