/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.resources.Resources;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class ResourcesSaveData
extends SavedData {
    public final ArrayList<Resources> resources = new ArrayList();

    private static ResourcesSaveData create() {
        return new ResourcesSaveData();
    }

    @Nonnull
    public static ResourcesSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return ResourcesSaveData.create();
        }
        return (ResourcesSaveData)server.m_129783_().m_8895_().m_164861_(ResourcesSaveData::load, ResourcesSaveData::create, "saved-resources-data");
    }

    public static ResourcesSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("ResourcesSaveData.load");
        ResourcesSaveData data = ResourcesSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("resources");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag ptag = (CompoundTag)ctag;
                String ownerName = ptag.m_128461_("ownerName");
                int food = ptag.m_128451_("food");
                int wood = ptag.m_128451_("wood");
                int ore = ptag.m_128451_("ore");
                data.resources.add(new Resources(ownerName, food, wood, ore));
                ReignOfNether.LOGGER.info("ResourcesSaveData.load: " + ownerName + "|" + food + "|" + wood + "|" + ore);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.resources.forEach(r -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("ownerName", r.ownerName);
            cTag.m_128405_("food", r.food);
            cTag.m_128405_("wood", r.wood);
            cTag.m_128405_("ore", r.ore);
            list.add((Object)cTag);
            ReignOfNether.LOGGER.info("ResourcesSaveData.save: " + r.ownerName + "|" + r.food + "|" + r.wood + "|" + r.ore);
        });
        tag.m_128365_("resources", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

