/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.survival.SurvivalClientEvents;
import com.solegendary.reignofnether.survival.SurvivalSyncAction;
import com.solegendary.reignofnether.survival.WaveDifficulty;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SurvivalClientboundPacket {
    SurvivalSyncAction action;
    WaveDifficulty difficulty;
    long value;

    public static void enableAndSetDifficulty(WaveDifficulty diff) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SurvivalClientboundPacket(SurvivalSyncAction.ENABLE_AND_SET_DIFFICULTY, diff, 0L, 0L));
    }

    public static void setWaveNumber(long waveNumber) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SurvivalClientboundPacket(SurvivalSyncAction.SET_WAVE_NUMBER, WaveDifficulty.EASY, waveNumber, 0L));
    }

    public static void setWaveRandomSeed(long seed) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SurvivalClientboundPacket(SurvivalSyncAction.SET_WAVE_RANDOM_SEED, WaveDifficulty.EASY, seed, 0L));
    }

    public SurvivalClientboundPacket(SurvivalSyncAction action, WaveDifficulty difficulty, long value, long bonusTicks) {
        this.action = action;
        this.difficulty = difficulty;
        this.value = value;
    }

    public SurvivalClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (SurvivalSyncAction)buffer.m_130066_(SurvivalSyncAction.class);
        this.difficulty = (WaveDifficulty)buffer.m_130066_(WaveDifficulty.class);
        this.value = buffer.readLong();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130068_((Enum)this.difficulty);
        buffer.writeLong(this.value);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case ENABLE_AND_SET_DIFFICULTY: {
                    SurvivalClientEvents.enable(this.difficulty);
                    break;
                }
                case SET_WAVE_NUMBER: {
                    SurvivalClientEvents.setWaveNumber(this.value);
                    break;
                }
                case SET_WAVE_RANDOM_SEED: {
                    SurvivalClientEvents.setRandomSeed(this.value);
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

