/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.tutorial;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.villagers.Barracks;
import com.solegendary.reignofnether.building.buildings.villagers.OakBridge;
import com.solegendary.reignofnether.building.buildings.villagers.TownCentre;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.registrars.SoundRegistrar;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.tutorial.TutorialAction;
import com.solegendary.reignofnether.tutorial.TutorialRendering;
import com.solegendary.reignofnether.tutorial.TutorialServerboundPacket;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

public class TutorialClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static TutorialStage tutorialStage = TutorialStage.INTRO;
    private static boolean enabled = false;
    private static int ticksToProgressStage = 0;
    private static int ticksToNextStage = 0;
    private static int ticksOnStage = 0;
    private static int stageProgress = 0;
    private static boolean pressSpaceToContinue = false;
    private static boolean blockUpdateStage = false;
    public static boolean pannedUp = false;
    public static boolean pannedDown = false;
    public static boolean pannedLeft = false;
    public static boolean pannedRight = false;
    public static boolean clickedMinimap = false;
    private static int villagersHoldingFood = 0;
    private static final ArrayList<BuildingPlacement> damagedBuildings = new ArrayList();
    private static final Vec3i SPAWN_CAM_POS = new Vec3i(-2960, 0, -1156);
    public static final Vec3i BUILD_CAM_POS = new Vec3i(-2954, 0, -1190);
    private static final Vec3i WOOD_CAM_POS = new Vec3i(-2929, 0, -1186);
    private static final Vec3i ORE_CAM_POS = new Vec3i(-2961, 0, -1214);
    private static final Vec3i FOOD_CAM_POS = new Vec3i(-2949, 0, -1163);
    private static final Vec3i MONSTER_CAM_POS = new Vec3i(-2993, 64, -1189);
    private static final Vec3i BRIDGE_CAM_POS = new Vec3i(-3007, 0, -1196);
    private static final Vec3i ARMY_CAM_POS = new Vec3i(-2973, 64, -1150);
    public static final Vec3i BUILD_CAPITOL_POS = new Vec3i(-2936, 67, -1217);
    private static final Vec3i MONSTER_BASE_POS = new Vec3i(-3085, 72, -1277);
    private static Supplier<Boolean> shouldPauseTicking = () -> false;
    private static int helpButtonClicks = 0;
    private static String helpButtonText = "";
    public static final Button helpButton = new Button("Tutorial Help", 18, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/help.png"), (Keybinding)null, () -> false, () -> !TutorialClientEvents.isEnabled(), () -> TutorialClientEvents.isEnabled() && !helpButtonText.isEmpty(), () -> {
        ++helpButtonClicks;
        if (TutorialClientEvents.getStage() == TutorialStage.INTRO) {
            TutorialClientEvents.specialMsg(helpButtonText, new Object[0]);
        } else {
            TutorialClientEvents.msg(helpButtonText, true, SoundRegistrar.CHAT, new Object[0]);
        }
    }, () -> {}, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"tutorial.reignofnether.tutorial_help", (Object[])new Object[0]), (Style)Style.f_131099_)));

    public static void loadStage(TutorialStage stage) {
        if (stage == null || stage == TutorialClientEvents.getStage() || stage == TutorialStage.INTRO || stage == TutorialStage.COMPLETED) {
            return;
        }
        TutorialClientEvents.specialMsg("tutorial.reignofnether.resuming", stage.name().replace("_", " "));
        tutorialStage = stage;
        ticksOnStage = 0;
        stageProgress = 0;
        blockUpdateStage = false;
        TutorialClientEvents.clearHelpButtonText();
        TutorialRendering.clearButtonName();
        TutorialClientEvents.updateStage();
        shouldPauseTicking = () -> false;
    }

    private static void setHelpButtonText(String text) {
        helpButtonClicks = 0;
        helpButtonText = I18n.m_118938_((String)text, (Object[])new Object[0]);
    }

    private static void clearHelpButtonText() {
        helpButtonClicks = 0;
        helpButtonText = "";
    }

    public static int getStageProgress() {
        return stageProgress;
    }

    public static boolean isEnabled() {
        return enabled && MC.m_91091_();
    }

    public static void setEnabled(boolean value) {
        if (value && !enabled && TutorialClientEvents.MC.f_91074_ != null) {
            TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
            TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.welcome2").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.get_started"));
            TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        }
        enabled = value;
    }

    public static TutorialStage getStage() {
        return tutorialStage;
    }

    private static void nextStage() {
        tutorialStage = tutorialStage.next();
        ticksOnStage = 0;
        stageProgress = 0;
        blockUpdateStage = false;
        TutorialClientEvents.clearHelpButtonText();
        TutorialRendering.clearButtonName();
        TutorialClientEvents.updateStage();
        shouldPauseTicking = () -> false;
        TutorialServerboundPacket.saveStage(tutorialStage);
    }

    private static void prevStage() {
        tutorialStage = tutorialStage.prev();
        ticksOnStage = 0;
        stageProgress = 0;
        blockUpdateStage = false;
        TutorialClientEvents.clearHelpButtonText();
        TutorialRendering.clearButtonName();
        TutorialClientEvents.updateStage();
        shouldPauseTicking = () -> false;
        TutorialServerboundPacket.saveStage(tutorialStage);
    }

    public static void checkAndRenderNextAction(GuiGraphics poseStack, ArrayList<Button> buttons) {
        if (tutorialStage == TutorialStage.PAN_CAMERA && TutorialClientEvents.MC.f_91080_ != null) {
            if (!pannedUp) {
                TutorialRendering.pointAtWithArrow(poseStack, TutorialClientEvents.MC.f_91080_.f_96543_ / 2, -Button.DEFAULT_ICON_FRAME_SIZE, true);
            }
            if (!pannedDown) {
                TutorialRendering.pointAtWithArrow(poseStack, TutorialClientEvents.MC.f_91080_.f_96543_ / 2, TutorialClientEvents.MC.f_91080_.f_96544_, true);
            }
            if (!pannedLeft) {
                TutorialRendering.pointAtWithArrow(poseStack, -Button.DEFAULT_ICON_FRAME_SIZE, TutorialClientEvents.MC.f_91080_.f_96544_ / 2, false);
            }
            if (!pannedRight) {
                TutorialRendering.pointAtWithArrow(poseStack, TutorialClientEvents.MC.f_91080_.f_96543_, TutorialClientEvents.MC.f_91080_.f_96544_ / 2, false);
            }
        } else {
            TutorialRendering.highlightNextButton(poseStack, buttons);
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre evt) {
        TutorialClientEvents.updateStage();
    }

    @SubscribeEvent
    public static void onKeyRelease(ScreenEvent.KeyReleased.Pre evt) {
        TutorialClientEvents.updateStage();
    }

    @SubscribeEvent
    public static void onKeyPress(ScreenEvent.KeyPressed.Pre evt) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (Keybindings.ctrlMod.isDown() && Keybindings.altMod.isDown() && evt.getKeyCode() == 32) {
            TutorialClientEvents.nextStage();
            TutorialClientEvents.specialMsg("tutorial.reignofnether.skipping", TutorialClientEvents.getStage().name());
        }
        if (pressSpaceToContinue && evt.getKeyCode() == 32) {
            pressSpaceToContinue = false;
            TutorialClientEvents.nextStage();
        }
        if (pressSpaceToContinue && evt.getKeyCode() == 32) {
            pressSpaceToContinue = false;
            TutorialClientEvents.nextStage();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || MC.m_91104_() || !TutorialClientEvents.isEnabled() || !OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (shouldPauseTicking.get().booleanValue()) {
            return;
        }
        if (ticksOnStage < Integer.MAX_VALUE) {
            if (ticksOnStage % 20 == 0) {
                TutorialClientEvents.updateStage();
            }
            ++ticksOnStage;
        }
        if (ticksToProgressStage > 0 && --ticksToProgressStage == 0) {
            TutorialClientEvents.progressStage();
        }
        if (ticksToNextStage > 0 && --ticksToNextStage == 0) {
            TutorialClientEvents.nextStage();
        }
    }

    private static void msg(String msg, boolean bold, RegistryObject<SoundEvent> soundEvt, Object ... params) {
        if (TutorialClientEvents.MC.f_91074_ == null) {
            return;
        }
        TutorialClientEvents.MC.f_91074_.m_5496_((SoundEvent)soundEvt.get(), 1.2f, 1.0f);
        TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
        if (bold) {
            TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)msg, (Object[])params).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        } else {
            TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)msg, (Object[])params));
        }
        TutorialClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
    }

    private static void msg(String msg) {
        TutorialClientEvents.msg(msg, false, SoundRegistrar.CHAT, new Object[0]);
    }

    private static void specialMsg(String msg, Object ... params) {
        TutorialClientEvents.msg(msg, true, SoundRegistrar.ALLY, params);
    }

    public static boolean isAtOrPastStage(TutorialStage stage) {
        if (!TutorialClientEvents.isEnabled()) {
            return true;
        }
        return tutorialStage.ordinal() >= stage.ordinal();
    }

    private static void progressStage() {
        blockUpdateStage = false;
        ++stageProgress;
        TutorialClientEvents.updateStage();
    }

    private static void progressStageAfterDelay(int delay) {
        blockUpdateStage = true;
        ticksToProgressStage = delay;
    }

    private static void nextStageAfterDelay(int delay) {
        blockUpdateStage = true;
        ticksToNextStage = delay;
        TutorialClientEvents.clearHelpButtonText();
        TutorialRendering.clearButtonName();
    }

    private static void nextStageAfterSpace() {
        blockUpdateStage = true;
        TutorialClientEvents.msg("tutorial.reignofnether.ready_continue", true, SoundRegistrar.CHAT, new Object[0]);
        TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.ready_continue");
        TutorialRendering.clearButtonName();
        pressSpaceToContinue = true;
    }

    private static boolean hasUnitSelected(String unitName) {
        return UnitClientEvents.getSelectedUnits().size() > 0 && UnitClientEvents.getSelectedUnits().get(0).m_7755_().getString().toLowerCase().contains(unitName.toLowerCase());
    }

    private static boolean hasBuildingSelected(Building building) {
        return BuildingClientEvents.getSelectedBuildings().size() > 0 && BuildingClientEvents.getSelectedBuildings().get(0).getBuilding() == building;
    }

    public static void updateStage() {
        if (!TutorialClientEvents.isEnabled() || blockUpdateStage) {
            return;
        }
        block0 : switch (tutorialStage) {
            case INTRO: {
                if (stageProgress == 0 && OrthoviewClientEvents.isEnabled()) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    OrthoviewClientEvents.lockCam();
                    TutorialClientEvents.msg("tutorial.reignofnether.rts_view");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.see_again");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.reminder");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.need_click");
                    TutorialRendering.setButtonName(TutorialClientEvents.helpButton.name);
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 3 || helpButtonClicks <= 0) break;
                TutorialClientEvents.nextStageAfterDelay(120);
                break;
            }
            case PAN_CAMERA: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    OrthoviewClientEvents.unlockCam();
                    TutorialClientEvents.msg("tutorial.reignofnether.move_camera");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.move_camera2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 1 || !pannedUp || !pannedDown || !pannedLeft || !pannedRight) break;
                TutorialClientEvents.specialMsg("tutorial.reignofnether.nicely_done", new Object[0]);
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case CAMERA_TIPS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.arrow_keys");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.zoom");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress != 2) break;
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case MINIMAP_CLICK: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.minimap");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 1) {
                    clickedMinimap = false;
                    TutorialClientEvents.msg("tutorial.reignofnether.map_click");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.map_click2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 2 || !clickedMinimap) break;
                TutorialClientEvents.specialMsg("tutorial.reignofnether.good_work", new Object[0]);
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case MINIMAP_TIPS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.recenter");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.expand_map");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress != 2) break;
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case PLACE_WORKERS_A: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.playing_units");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress != 1) break;
                TutorialClientEvents.msg("tutorial.reignofnether.spawn_villagers");
                OrthoviewClientEvents.forceMoveCam(SPAWN_CAM_POS, 50);
                OrthoviewClientEvents.lockCam();
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case PLACE_WORKERS_B: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.spawn_villagers2");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.spawn_villagers2");
                    TutorialRendering.setButtonName("tutorial.reignofnether.villagers");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 1 || !PlayerClientEvents.isRTSPlayer()) break;
                TutorialRendering.clearButtonName();
                TutorialClientEvents.specialMsg("tutorial.reignofnether.excellent", new Object[0]);
                OrthoviewClientEvents.unlockCam();
                TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case SELECT_UNIT: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.worker_units");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.select_worker");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.select_worker2");
                    UnitClientEvents.clearSelectedUnits();
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 2 || !TutorialClientEvents.hasUnitSelected("villager")) break;
                TutorialClientEvents.nextStage();
                break;
            }
            case MOVE_UNIT: {
                Unit unit;
                MoveToTargetBlockGoal goal;
                if (stageProgress == 0 && TutorialClientEvents.hasUnitSelected("villager")) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.move_worker");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.move_worker2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 1 || !TutorialClientEvents.hasUnitSelected("villager") || (goal = (unit = (Unit)UnitClientEvents.getSelectedUnits().get(0)).getMoveGoal()) == null || goal.getMoveTarget() == null) break;
                TutorialClientEvents.specialMsg("tutorial.reignofnether.nice_work", new Object[0]);
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case BOX_SELECT_UNITS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.select_villagers");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.select_villagers2");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.select_villagers3");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 2 || UnitClientEvents.getSelectedUnits().size() <= 1) break;
                TutorialClientEvents.nextStage();
                break;
            }
            case MOVE_UNITS: {
                Unit unit;
                MoveToTargetBlockGoal goal;
                if (stageProgress == 0 && UnitClientEvents.getSelectedUnits().size() > 1) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.move_group");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.move_group2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 1 || UnitClientEvents.getSelectedUnits().size() <= 1 || (goal = (unit = (Unit)UnitClientEvents.getSelectedUnits().get(1)).getMoveGoal()) == null || goal.getMoveTarget() == null) break;
                TutorialClientEvents.specialMsg("tutorial.reignofnether.great_job", new Object[0]);
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case UNIT_TIPS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.select_same");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.deselect");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.grouping");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress != 3) break;
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case BUILD_INTRO: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.start_base");
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.capitol");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.good_spot");
                    OrthoviewClientEvents.forceMoveCam(BUILD_CAM_POS, 50);
                    TutorialClientEvents.progressStageAfterDelay(180);
                    break;
                }
                if (stageProgress != 3) break;
                TutorialClientEvents.msg("tutorial.reignofnether.building_resources");
                TutorialClientEvents.nextStageAfterDelay(120);
                break;
            }
            case BUILD_TOWN_CENTRE: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.place_capitol");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.place_capitol2");
                    TutorialRendering.setButtonName("Town Centre");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 1 || BuildingClientEvents.getBuildings().size() <= 0 || !(BuildingClientEvents.getBuildings().get(0).getBuilding() instanceof TownCentre)) break;
                TutorialClientEvents.nextStage();
                break;
            }
            case BUILDING_TIPS: {
                Building goal;
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.all_workers_build");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.wait_for_capitol");
                    TutorialClientEvents.progressStageAfterDelay(240);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.select_building");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 2 || BuildingClientEvents.getBuildings().size() <= 0 || !((goal = BuildingClientEvents.getBuildings().get(0).getBuilding()) instanceof TownCentre)) break;
                TownCentre townCentre = (TownCentre)goal;
                if (!BuildingClientEvents.getBuildings().get((int)0).isBuilt) break;
                TutorialClientEvents.specialMsg("tutorial.reignofnether.congratulations", new Object[0]);
                TutorialClientEvents.nextStageAfterDelay(100);
                break;
            }
            case TRAIN_WORKER: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.capitols_produce_workers");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.worker_cost");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.rally_point");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.rally_point2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 3 && BuildingClientEvents.getBuildings().size() > 0) {
                    ProductionPlacement townCentre;
                    BuildingPlacement goal;
                    if (!(BuildingClientEvents.getBuildings().get(0).getBuilding() instanceof TownCentre) || !((goal = BuildingClientEvents.getBuildings().get(0)) instanceof ProductionPlacement) || (townCentre = (ProductionPlacement)goal).getFinalRallyPoint() == null) break;
                    TutorialClientEvents.msg("tutorial.reignofnether.make_villager");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.make_villager2");
                    TutorialRendering.setButtonName("Villager");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 4 && BuildingClientEvents.getBuildings().size() > 0) {
                    BuildingPlacement goal;
                    if (!(BuildingClientEvents.getBuildings().get(0).getBuilding() instanceof TownCentre) || !((goal = BuildingClientEvents.getBuildings().get(0)) instanceof ProductionPlacement)) break;
                    ProductionPlacement townCentre = (ProductionPlacement)goal;
                    if (townCentre.productionQueue.size() <= 0) break;
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.queue");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 5 && UnitClientEvents.getAllUnits().size() > 3) {
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.nice_work_workers", new Object[0]);
                    TutorialClientEvents.clearHelpButtonText();
                    TutorialRendering.clearButtonName();
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 6) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.cancel");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress != 7) break;
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case GATHER_WOOD: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.gather_resources");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.forest");
                    OrthoviewClientEvents.forceMoveCam(WOOD_CAM_POS, 100);
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.gather_wood");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.gather_wood2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 3) {
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        VillagerUnit villager;
                        if (!(entity instanceof VillagerUnit) || !(villager = (VillagerUnit)entity).getGatherResourceGoal().isGathering() || villager.getGatherResourceGoal().getTargetResourceName() != ResourceName.WOOD) continue;
                        TutorialClientEvents.specialMsg("tutorial.reignofnether.well_done", new Object[0]);
                        TutorialClientEvents.clearHelpButtonText();
                        TutorialClientEvents.progressStageAfterDelay(100);
                        break block0;
                    }
                    break;
                }
                if (stageProgress != 4) break;
                TutorialClientEvents.msg("tutorial.reignofnether.tip.autoreturn");
                TutorialClientEvents.nextStageAfterDelay(160);
                break;
            }
            case GATHER_ORE: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.gather_ore");
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.beach_ore");
                    OrthoviewClientEvents.forceMoveCam(ORE_CAM_POS, 50);
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.click_ore");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.click_ore2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 3) {
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        VillagerUnit villager;
                        if (!(entity instanceof VillagerUnit) || !(villager = (VillagerUnit)entity).getGatherResourceGoal().isGathering() || villager.getGatherResourceGoal().getTargetResourceName() != ResourceName.ORE) continue;
                        TutorialClientEvents.specialMsg("tutorial.reignofnether.well_done", new Object[0]);
                        TutorialClientEvents.clearHelpButtonText();
                        TutorialClientEvents.progressStageAfterDelay(100);
                        break block0;
                    }
                    break;
                }
                if (stageProgress != 4) break;
                TutorialClientEvents.msg("tutorial.reignofnether.tip.sand_richer");
                TutorialClientEvents.nextStageAfterDelay(120);
                break;
            }
            case HUNT_ANIMALS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.gather_food");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 1) {
                    OrthoviewClientEvents.forceMoveCam(FOOD_CAM_POS, 50);
                    TutorialServerboundPacket.doServerAction(TutorialAction.SPAWN_ANIMALS);
                    TutorialClientEvents.msg("tutorial.reignofnether.pigs");
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.hunt_pig");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.hunt_pig2");
                    TutorialClientEvents.progressStageAfterDelay(180);
                    break;
                }
                if (stageProgress == 3) {
                    TutorialClientEvents.msg("tutorial.reignofnether.empty_pockets");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 4) {
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        VillagerUnit villager;
                        LivingEntity targetEntity;
                        if (!(entity instanceof VillagerUnit) || !ResourceSources.isHuntableAnimal(targetEntity = (villager = (VillagerUnit)entity).m_5448_()) || !(targetEntity.m_21223_() < targetEntity.m_21233_())) continue;
                        TutorialClientEvents.msg("tutorial.reignofnether.tip.dropped");
                        TutorialClientEvents.progressStage();
                        break block0;
                    }
                    break;
                }
                if (stageProgress == 5) {
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        VillagerUnit villager;
                        LivingEntity targetEntity;
                        if (!(entity instanceof VillagerUnit) || !ResourceSources.isHuntableAnimal(targetEntity = (villager = (VillagerUnit)entity).m_5448_()) || !(targetEntity.m_21223_() < targetEntity.m_21233_() / 2.0f)) continue;
                        TutorialClientEvents.msg("tutorial.reignofnether.tip.pick_up");
                        TutorialClientEvents.progressStage();
                        break block0;
                    }
                    break;
                }
                if (stageProgress == 6) {
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        if (!(entity instanceof VillagerUnit)) continue;
                        VillagerUnit villager = (VillagerUnit)entity;
                        for (ItemStack itemStack : villager.getItems()) {
                            if (Resources.getTotalResourcesFromItems(List.of(itemStack)).food < 100) continue;
                            ++villagersHoldingFood;
                        }
                    }
                    if (villagersHoldingFood <= 0) break;
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.great_work", new Object[0]);
                    TutorialClientEvents.clearHelpButtonText();
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 7) {
                    TutorialClientEvents.msg("tutorial.reignofnether.return_food");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.return_food2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 8) {
                    int villagersHoldingFoodNow = 0;
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        if (!(entity instanceof VillagerUnit)) continue;
                        VillagerUnit villager = (VillagerUnit)entity;
                        for (ItemStack itemStack : villager.getItems()) {
                            Resources res = Resources.getTotalResourcesFromItems(List.of(itemStack));
                            if (res.food <= 0) continue;
                            ++villagersHoldingFoodNow;
                        }
                    }
                    if (villagersHoldingFoodNow >= villagersHoldingFood) break;
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.excellent", new Object[0]);
                    TutorialClientEvents.clearHelpButtonText();
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress != 9) break;
                TutorialClientEvents.msg("tutorial.reignofnether.tip.max_carry");
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case EXPLAIN_BUILDINGS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.expand_base");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.new_buildings");
                    shouldPauseTicking = () -> UnitClientEvents.getSelectedUnits().isEmpty() || !(UnitClientEvents.getSelectedUnits().get(0) instanceof VillagerUnit) || BuildingClientEvents.getBuildingToPlace() != null;
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress == 1 && TutorialClientEvents.hasUnitSelected("villager")) {
                    TutorialRendering.setButtonName("Stockpile");
                    TutorialClientEvents.msg("tutorial.reignofnether.stockpiles");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 2 && TutorialClientEvents.hasUnitSelected("villager")) {
                    TutorialRendering.setButtonName("Villager House");
                    TutorialClientEvents.msg("tutorial.reignofnether.houses");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 3 && TutorialClientEvents.hasUnitSelected("villager")) {
                    TutorialRendering.setButtonName("Wheat Farm");
                    TutorialClientEvents.msg("tutorial.reignofnether.farms");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 4 && TutorialClientEvents.hasUnitSelected("villager")) {
                    TutorialClientEvents.clearHelpButtonText();
                    TutorialRendering.setButtonName("Barracks");
                    TutorialClientEvents.msg("tutorial.reignofnether.barracks");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                TutorialClientEvents.nextStage();
                break;
            }
            case BUILD_BASE: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialRendering.clearButtonName();
                    TutorialClientEvents.msg("tutorial.reignofnether.check_out_buildings");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.build_barracks");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.build_barracks2");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress != 2) break;
                for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                    if (!(building.getBuilding() instanceof Barracks) || !building.isBuilt) continue;
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.great_job", new Object[0]);
                    TutorialClientEvents.nextStageAfterDelay(100);
                    break block0;
                }
                break;
            }
            case EXPLAIN_BARRACKS: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.msg("tutorial.reignofnether.select_barracks");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.select_barracks2");
                    shouldPauseTicking = () -> BuildingClientEvents.getSelectedBuildings().isEmpty() || !(BuildingClientEvents.getSelectedBuildings().get(0).getBuilding() instanceof Barracks);
                    TutorialClientEvents.progressStageAfterDelay(140);
                    break;
                }
                if (stageProgress == 1 && TutorialClientEvents.hasBuildingSelected(Buildings.BARRACKS)) {
                    TutorialRendering.setButtonName("Vindicator");
                    TutorialClientEvents.msg("tutorial.reignofnether.vindicators");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 2 && TutorialClientEvents.hasBuildingSelected(Buildings.BARRACKS)) {
                    TutorialClientEvents.clearHelpButtonText();
                    TutorialRendering.setButtonName("Pillager");
                    TutorialClientEvents.msg("tutorial.reignofnether.pillagers");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress != 3) break;
                TutorialClientEvents.nextStage();
                break;
            }
            case BUILD_ARMY: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.produce_illagers");
                    TutorialRendering.clearButtonName();
                    TutorialClientEvents.msg("tutorial.reignofnether.three_units");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 1) {
                    int armyCount = 0;
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        if (!(entity instanceof VindicatorUnit) && !(entity instanceof PillagerUnit)) continue;
                        ++armyCount;
                    }
                    if (armyCount < 3) break;
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.awesome", new Object[0]);
                    TutorialClientEvents.progressStageAfterDelay(100);
                    TutorialServerboundPacket.doServerAction(TutorialAction.SPAWN_MONSTER_WORKERS);
                    break;
                }
                if (stageProgress != 2) break;
                TutorialClientEvents.msg("tutorial.reignofnether.tip.select_military");
                TutorialClientEvents.nextStageAfterDelay(200);
                TutorialServerboundPacket.doServerAction(TutorialAction.START_MONSTER_BASE);
                break;
            }
            case DEFEND_BASE: {
                if (stageProgress == 0) {
                    TutorialClientEvents.msg("tutorial.reignofnether.monster_attack");
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_NIGHT_TIME);
                    TutorialServerboundPacket.doServerAction(TutorialAction.SPAWN_MONSTERS_A);
                    OrthoviewClientEvents.forceMoveCam(MONSTER_CAM_POS, 50);
                    TutorialClientEvents.progressStageAfterDelay(120);
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.attack");
                    TutorialClientEvents.msg("tutorial.reignofnether.attack");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.ATTACK_WITH_MONSTERS_A);
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 3) {
                    if (UnitClientEvents.getAllUnits().stream().filter(u -> u instanceof PillagerUnit || u instanceof VindicatorUnit).toList().isEmpty()) {
                        TutorialClientEvents.progressStage();
                    }
                    if (!UnitClientEvents.getAllUnits().stream().filter(u -> u instanceof ZombieUnit || u instanceof SkeletonUnit).toList().isEmpty()) break;
                    TutorialClientEvents.msg("tutorial.reignofnether.more_incoming");
                    TutorialServerboundPacket.doServerAction(TutorialAction.SPAWN_MONSTERS_B);
                    OrthoviewClientEvents.forceMoveCam(MONSTER_CAM_POS, 50);
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 4) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.ATTACK_WITH_MONSTERS_B);
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress == 5) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.EXPAND_MONSTER_BASE_A);
                    TutorialServerboundPacket.doServerAction(TutorialAction.SET_DAY_TIME);
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.dawn_breaks", new Object[0]);
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 6) {
                    if (!UnitClientEvents.getAllUnits().stream().filter(u -> u instanceof ZombieUnit || u instanceof SkeletonUnit).toList().isEmpty()) break;
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.defended", new Object[0]);
                    TutorialClientEvents.clearHelpButtonText();
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress != 7) break;
                TutorialClientEvents.msg("tutorial.reignofnether.tip.death_drops");
                TutorialClientEvents.nextStageAfterDelay(200);
                break;
            }
            case REPAIR_BUILDING: {
                if (stageProgress == 0) {
                    TutorialServerboundPacket.doServerAction(TutorialAction.EXPAND_MONSTER_BASE_B);
                    for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                        if (building.getHealth() >= building.getMaxHealth() || building.getFaction() != Faction.VILLAGERS || damagedBuildings.size() >= 3) continue;
                        damagedBuildings.add(building);
                    }
                    if (damagedBuildings.isEmpty()) {
                        TutorialClientEvents.nextStage();
                        break;
                    }
                    TutorialClientEvents.msg("tutorial.reignofnether.buildings_damaged");
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.repair_buildings");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.repair_buildings2");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 2) {
                    for (BuildingPlacement building : damagedBuildings) {
                        if (building.getHealth() < building.getMaxHealth()) continue;
                        TutorialClientEvents.specialMsg("tutorial.reignofnether.good_job", new Object[0]);
                        TutorialClientEvents.clearHelpButtonText();
                        TutorialClientEvents.progressStageAfterDelay(100);
                        break block0;
                    }
                    break;
                }
                if (stageProgress == 3) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.building_health");
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress != 4) break;
                TutorialServerboundPacket.doServerAction(TutorialAction.SPAWN_MONSTER_BASE_ARMY);
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case BUILD_BRIDGE: {
                if (stageProgress == 0) {
                    OrthoviewClientEvents.forceMoveCam(MONSTER_BASE_POS, 80);
                    if (FogOfWarClientEvents.isEnabled()) {
                        TutorialClientEvents.msg("tutorial.reignofnether.monster_base");
                    } else {
                        TutorialClientEvents.msg("tutorial.reignofnether.monster_base2");
                    }
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.build_bridge");
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 2) {
                    OrthoviewClientEvents.forceMoveCam(BRIDGE_CAM_POS, 50);
                    TutorialClientEvents.msg("tutorial.reignofnether.build_bridge2");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.build_bridge3");
                    TutorialClientEvents.progressStage();
                    break;
                }
                if (stageProgress == 3) {
                    for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                        if (!(building.getBuilding() instanceof OakBridge)) continue;
                        TutorialClientEvents.msg("tutorial.reignofnether.tip.bridge_segments");
                        TutorialClientEvents.progressStage();
                        break block0;
                    }
                    break;
                }
                if (stageProgress == 4) {
                    for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                        if (!(building.getBuilding() instanceof OakBridge) || !building.isBuilt) continue;
                        TutorialClientEvents.specialMsg("tutorial.reignofnether.nice_job", new Object[0]);
                        TutorialClientEvents.progressStageAfterDelay(100);
                        break block0;
                    }
                    break;
                }
                if (stageProgress == 5) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.bridges_neutral");
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress == 6) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.crossing_bridges");
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress != 7) break;
                TutorialClientEvents.nextStage();
                break;
            }
            case ATTACK_ENEMY_BASE: {
                if (stageProgress == 0) {
                    TutorialClientEvents.msg("tutorial.reignofnether.reinforcements");
                    TutorialServerboundPacket.doServerAction(TutorialAction.SPAWN_FRIENDLY_ARMY);
                    OrthoviewClientEvents.forceMoveCam(ARMY_CAM_POS, 50);
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.iron_golem");
                    TutorialClientEvents.setHelpButtonText("tutorial.reignofnether.destroy_monster_base");
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.tip.ranged_no_buildings");
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress == 3) {
                    for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                        if (building.getFaction() != Faction.MONSTERS || building.getHealth() >= building.getMaxHealth()) continue;
                        TutorialClientEvents.msg("tutorial.reignofnether.tip.monster_capitol");
                        TutorialClientEvents.progressStage();
                        break block0;
                    }
                    break;
                }
                if (stageProgress == 4) {
                    boolean botAlive = false;
                    for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                        if (building.getFaction() != Faction.MONSTERS) continue;
                        botAlive = true;
                    }
                    if (botAlive) break;
                    TutorialClientEvents.progressStageAfterDelay(200);
                    break;
                }
                if (stageProgress != 5) break;
                TutorialClientEvents.nextStageAfterSpace();
                break;
            }
            case OUTRO: {
                if (stageProgress == 0) {
                    TutorialClientEvents.specialMsg("tutorial.reignofnether.congratulations_tutorial", new Object[0]);
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress == 1) {
                    TutorialClientEvents.msg("tutorial.reignofnether.continue");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 2) {
                    TutorialClientEvents.msg("tutorial.reignofnether.reset_game");
                    TutorialClientEvents.progressStageAfterDelay(120);
                    break;
                }
                if (stageProgress == 3) {
                    TutorialClientEvents.msg("tutorial.reignofnether.server_hosting");
                    TutorialClientEvents.progressStageAfterDelay(160);
                    break;
                }
                if (stageProgress == 4) {
                    TutorialClientEvents.msg("tutorial.reignofnether.good_luck");
                    TutorialClientEvents.progressStageAfterDelay(100);
                    break;
                }
                if (stageProgress != 5) break;
                TutorialClientEvents.specialMsg("tutorial.reignofnether.tutorial_disabled", new Object[0]);
                TutorialClientEvents.nextStage();
                break;
            }
            case COMPLETED: {
                if (stageProgress != 0) break;
                TutorialClientEvents.setEnabled(false);
                TutorialClientEvents.progressStage();
            }
        }
    }
}

