/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class Checkpoint {
    public static final int CHECKPOINT_TICKS_FADE = 15;
    public final BlockPos bp;
    public final Entity entity;
    public final BuildingPlacement placement;
    public final boolean isGreen;
    private boolean isFading = false;
    public int ticksLeft = 15;

    public Checkpoint(BlockPos bp, boolean isGreen) {
        this.bp = bp;
        this.entity = null;
        this.isGreen = isGreen;
        this.placement = BuildingUtils.findBuilding(true, bp);
    }

    public Checkpoint(Entity entity, boolean isGreen) {
        this.bp = null;
        this.entity = entity;
        this.isGreen = isGreen;
        this.placement = null;
    }

    public void startFading() {
        this.isFading = true;
    }

    public void tick() {
        if (this.isFading && this.ticksLeft > 0) {
            --this.ticksLeft;
        }
    }

    public boolean isForEntity() {
        return this.entity != null;
    }

    public Vec3 getPos() {
        if (this.isForEntity()) {
            return this.entity.m_146892_().m_82520_(0.0, (double)(1.74f - this.entity.m_20192_() - 1.0f), 0.0);
        }
        return new Vec3((double)((float)this.bp.m_123341_() + 0.5f), (double)((float)this.bp.m_123342_() + 1.0f), (double)((float)this.bp.m_123343_() + 0.5f));
    }
}

