/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.util.MyMath;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class GenericTargetedSpellGoal
extends MoveToTargetBlockGoal {
    protected LivingEntity targetEntity = null;
    protected Ability ability;
    protected int channelTicks = 0;
    protected final int channelTicksMax;
    protected boolean isCasting = false;
    protected BlockPos castTarget = null;
    protected final float range;
    public Consumer<LivingEntity> onEntityCast;
    public Consumer<BlockPos> onGroundCast;
    public Consumer<BuildingPlacement> onBuildingCast;
    public boolean hasKeyframeAnimations = false;
    protected float bonusChannelingRange = 0.0f;
    protected final UnitAnimationAction animationStart;

    public boolean isCasting() {
        return this.isCasting;
    }

    public GenericTargetedSpellGoal(Mob mob, int channelTicksMax, float range, UnitAnimationAction animationStart, @Nullable Consumer<LivingEntity> onEntityCast, @Nullable Consumer<BlockPos> onGroundCast, @Nullable Consumer<BuildingPlacement> onBuildingCast) {
        super(mob, false, 0);
        this.channelTicksMax = channelTicksMax;
        this.range = range;
        this.animationStart = animationStart;
        if (this.animationStart != null) {
            this.hasKeyframeAnimations = true;
        }
        this.onEntityCast = onEntityCast;
        this.onGroundCast = onGroundCast;
        this.onBuildingCast = onBuildingCast;
    }

    public GenericTargetedSpellGoal(Mob mob, int channelTicksMax, float range, @Nullable Consumer<LivingEntity> onEntityCast, @Nullable Consumer<BlockPos> onGroundCast, @Nullable Consumer<BuildingPlacement> onBuildingCast) {
        super(mob, false, 0);
        this.channelTicksMax = channelTicksMax;
        this.range = range;
        this.animationStart = null;
        this.onEntityCast = onEntityCast;
        this.onGroundCast = onGroundCast;
        this.onBuildingCast = onBuildingCast;
    }

    public void setTarget(LivingEntity entity) {
        if (entity != this.mob) {
            this.targetEntity = entity;
        }
    }

    public void setTarget(BlockPos bpTarget) {
        this.setMoveTarget(bpTarget);
        this.setTarget((LivingEntity)null);
    }

    public void setTarget(BuildingPlacement building) {
        this.setMoveTarget(building.centrePos);
        this.setTarget((LivingEntity)null);
    }

    public LivingEntity getTargetEntity() {
        return this.targetEntity;
    }

    public void setAbility(Ability ability) {
        this.ability = ability;
    }

    protected boolean isInRange() {
        float finalRange = this.range;
        if (this.isCasting()) {
            finalRange += this.bonusChannelingRange;
        }
        if (this.moveTarget != null && MyMath.distance(this.mob.m_20185_(), this.mob.m_20189_(), this.moveTarget.m_123341_(), this.moveTarget.m_123343_()) <= (double)finalRange) {
            return true;
        }
        return this.castTarget != null && MyMath.distance(this.mob.m_20185_(), this.mob.m_20189_(), this.castTarget.m_123341_(), this.castTarget.m_123343_()) <= (double)finalRange;
    }

    public void m_8037_() {
        if (this.targetEntity != null) {
            this.setMoveTarget(this.targetEntity.m_20097_());
        }
        if (this.moveTarget != null || this.castTarget != null) {
            if (this.isInRange()) {
                if (this.moveTarget != null) {
                    this.castTarget = this.moveTarget;
                }
                if (!this.isCasting) {
                    this.startCasting();
                }
                this.stopMoving();
            } else {
                this.stopCasting();
                this.setMoveTarget(this.moveTarget);
            }
            if (this.isCasting && this.castTarget != null) {
                this.mob.m_21563_().m_24946_((double)this.castTarget.m_123341_(), (double)this.castTarget.m_123342_(), (double)this.castTarget.m_123343_());
                ++this.channelTicks;
                if (this.channelTicks >= this.channelTicksMax) {
                    if (this.onEntityCast != null && this.targetEntity != null) {
                        this.onEntityCast.accept(this.targetEntity);
                    } else if (this.onGroundCast != null || this.onBuildingCast != null) {
                        BuildingPlacement targetBuilding = BuildingUtils.findBuilding(this.mob.m_9236_().m_5776_(), this.castTarget);
                        if (this.onBuildingCast != null && targetBuilding != null) {
                            this.onBuildingCast.accept(targetBuilding);
                        } else if (this.onGroundCast != null) {
                            this.onGroundCast.accept(this.castTarget);
                        }
                    }
                    if (this.ability != null && !this.mob.m_9236_().m_5776_()) {
                        Mob mob;
                        if (!this.mob.m_9236_().m_5776_() && (mob = this.mob) instanceof Unit) {
                            Object object;
                            Unit unit = (Unit)mob;
                            if (this.ability.isOffCooldown(unit)) {
                                AbilityClientboundPacket.sendSetCooldownPacket(this.mob.m_19879_(), this.ability.action, this.ability.cooldownMax);
                            }
                            if ((object = this.mob) instanceof HeroUnit) {
                                HeroUnit heroUnit = (HeroUnit)object;
                                object = this.ability;
                                if (object instanceof HeroAbility) {
                                    HeroAbility heroAbility = (HeroAbility)object;
                                    heroUnit.setMana(heroUnit.getMana() - (float)heroAbility.manaCost);
                                }
                            }
                        } else {
                            Unit unit;
                            mob = this.mob;
                            if (mob instanceof Unit && this.ability.isOffCooldown(unit = (Unit)mob)) {
                                this.ability.setToMaxCooldown(unit);
                            }
                        }
                    }
                    this.stopExceptAnimations();
                }
            }
        }
    }

    public BlockPos getCastTarget() {
        return this.castTarget;
    }

    public void startCasting() {
        this.isCasting = true;
        this.castTarget = this.moveTarget;
        if (!this.mob.m_9236_().m_5776_()) {
            if (!this.hasKeyframeAnimations) {
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_START, (LivingEntity)this.mob);
            } else if (this.animationStart != null) {
                UnitAnimationClientboundPacket.sendBasicPacket(this.animationStart, (LivingEntity)this.mob);
            }
        }
    }

    public void stopCasting() {
        this.isCasting = false;
        this.channelTicks = 0;
        this.castTarget = null;
        if (!this.mob.m_9236_().m_5776_() && this.channelTicks < this.channelTicksMax) {
            if (!this.hasKeyframeAnimations) {
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_STOP, (LivingEntity)this.mob);
            } else {
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.STOP, (LivingEntity)this.mob);
            }
        }
    }

    public void m_8041_() {
        this.stopMoving();
        this.setTarget((LivingEntity)null);
        this.stopCasting();
    }

    public void stopExceptAnimations() {
        this.stopMoving();
        this.setTarget((LivingEntity)null);
        this.isCasting = false;
        this.channelTicks = 0;
        this.castTarget = null;
    }
}

