/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.ability.abilities.ThrowHealingPotion;
import com.solegendary.reignofnether.ability.abilities.ThrowLingeringHarmingPotion;
import com.solegendary.reignofnether.ability.abilities.ThrowLingeringRegenPotion;
import com.solegendary.reignofnether.ability.abilities.ThrowWaterPotion;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.WitchUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class ThrowPotionGoal
extends MoveToTargetBlockGoal {
    private Potion potion = null;
    private LivingEntity targetEntity = null;

    public ThrowPotionGoal(Mob mob) {
        super(mob, false, 0);
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
    }

    public void setTarget(LivingEntity entity) {
        this.targetEntity = entity;
    }

    public void setTarget(BlockPos bpTarget) {
        this.setMoveTarget(bpTarget);
        this.setTarget((LivingEntity)null);
    }

    public void m_8037_() {
        if (this.targetEntity != null) {
            this.setMoveTarget(this.targetEntity.m_20097_());
        }
        WitchUnit witch = (WitchUnit)this.mob;
        if (this.moveTarget != null && MyMath.distance(this.mob.m_20185_(), this.mob.m_20189_(), this.moveTarget.m_123341_(), this.moveTarget.m_123343_()) <= (double)witch.getPotionThrowRange()) {
            this.mob.m_21563_().m_24946_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_());
            if (this.moveTarget != null) {
                witch.throwPotion(new Vec3((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_()), this.potion);
                if (!this.mob.m_9236_().m_5776_()) {
                    for (Ability potionAbility : witch.getAbilities().get()) {
                        AbilityClientboundPacket.sendSetCooldownPacket(this.mob.m_19879_(), potionAbility.action, potionAbility.cooldownMax);
                    }
                }
            }
            this.m_8041_();
        }
        if (this.targetEntity == null && this.moveTarget == null && !this.mob.m_9236_().m_5776_() && witch.isIdle() && witch.f_19797_ % 4 == 0) {
            for (Ability potionAbility : witch.getAbilities().get()) {
                if (!potionAbility.isAutocasting(witch) || !potionAbility.isOffCooldown(witch)) continue;
                List<Mob> nearbyMobs = MiscUtil.getEntitiesWithinRange(new Vector3d(witch.m_20182_().f_82479_, witch.m_20182_().f_82480_, witch.m_20182_().f_82481_), potionAbility.range + 4.0f, Mob.class, witch.m_9236_());
                if (potionAbility instanceof ThrowLingeringRegenPotion || potionAbility instanceof ThrowHealingPotion) {
                    List<Mob> nearbyFriendlyHurtUnits = nearbyMobs.stream().filter(mb -> {
                        if (!(mb instanceof Unit)) return false;
                        Unit unit = (Unit)mb;
                        if (mb.m_6336_() == MobType.f_21641_) return false;
                        if (!(mb.m_21223_() < mb.m_21233_())) return false;
                        if (unit.getOwnerName().equals(witch.getOwnerName())) return true;
                        if (!AlliancesServerEvents.isAllied(unit.getOwnerName(), witch.getOwnerName())) return false;
                        return true;
                    }).sorted(Comparator.comparing(mb -> Float.valueOf(mb.m_21223_() / mb.m_21233_()))).toList();
                    if (nearbyFriendlyHurtUnits.isEmpty()) continue;
                    if (potionAbility instanceof ThrowLingeringRegenPotion) {
                        ThrowLingeringRegenPotion pa = (ThrowLingeringRegenPotion)potionAbility;
                        this.setPotion(pa.potion);
                    } else if (potionAbility instanceof ThrowHealingPotion) {
                        ThrowHealingPotion pa = (ThrowHealingPotion)potionAbility;
                        this.setPotion(pa.potion);
                    }
                    this.setTarget((LivingEntity)nearbyFriendlyHurtUnits.get(0));
                    break;
                }
                if (potionAbility instanceof ThrowWaterPotion) {
                    BlockPos fireBp;
                    ThrowWaterPotion throwWaterPotion = (ThrowWaterPotion)potionAbility;
                    List<Mob> nearbyOnFireUnits = nearbyMobs.stream().filter(mb -> {
                        if (!(mb instanceof Unit)) return false;
                        Unit unit = (Unit)mb;
                        if (!mb.m_6060_()) return false;
                        if (unit.getOwnerName().equals(witch.getOwnerName())) return true;
                        if (!AlliancesServerEvents.isAllied(unit.getOwnerName(), witch.getOwnerName())) return false;
                        return true;
                    }).sorted(Comparator.comparing(mb -> Float.valueOf(mb.m_21223_() / mb.m_21233_()))).toList();
                    if (!nearbyOnFireUnits.isEmpty()) {
                        this.setPotion(throwWaterPotion.potion);
                        this.setTarget((LivingEntity)nearbyOnFireUnits.get(0));
                        break;
                    }
                    if (witch.f_19797_ % 20 != 0 || (fireBp = this.findNearbyFireBlock()) == null) continue;
                    this.setPotion(throwWaterPotion.potion);
                    this.setTarget(fireBp);
                    break;
                }
                if (!(potionAbility instanceof ThrowLingeringHarmingPotion)) continue;
                ThrowLingeringHarmingPotion throwHarmingPotion = (ThrowLingeringHarmingPotion)potionAbility;
                List<Mob> nearbyEnemyUnits = nearbyMobs.stream().filter(mb -> {
                    if (!(mb instanceof Unit)) return false;
                    Unit unit = (Unit)mb;
                    if (mb.m_6336_() == MobType.f_21641_) return false;
                    if (unit.getOwnerName().equals(witch.getOwnerName())) return false;
                    if (AlliancesServerEvents.isAllied(unit.getOwnerName(), witch.getOwnerName())) return false;
                    return true;
                }).toList();
                if (nearbyEnemyUnits.isEmpty()) continue;
                this.setPotion(throwHarmingPotion.potion);
                this.setTarget((LivingEntity)nearbyEnemyUnits.get(0));
                break;
            }
        }
    }

    @Nullable
    private BlockPos findNearbyFireBlock() {
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        for (int x = -10; x < 10; ++x) {
            for (int y = -4; y < 4; ++y) {
                for (int z = -10; z < 10; ++z) {
                    BlockPos bp2 = this.mob.m_20183_().m_7918_(x, y, z);
                    if (this.mob.m_9236_().m_8055_(bp2).m_60734_() != Blocks.f_50083_) continue;
                    bps.add(bp2);
                }
            }
        }
        List<BlockPos> sortedBps = bps.stream().sorted(Comparator.comparing(bp -> bp.m_123331_((Vec3i)this.mob.m_20183_()))).toList();
        if (!sortedBps.isEmpty()) {
            return sortedBps.get(0);
        }
        return null;
    }

    public void m_8041_() {
        this.stopMoving();
        this.setTarget((LivingEntity)null);
        this.setPotion(null);
    }
}

