/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hero.HeroClientEvents;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.hero.HeroServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.HeroUnitSave;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public interface HeroUnit
extends Unit {
    public static final float EXP_REQ_MULTIPLIER = 1.6f;
    public static final int MAX_LEVEL = 10;
    public static final int MAX_NEUTRAL_EXP_LEVEL = 5;

    public static void tick(HeroUnit heroUnit) {
        if (((LivingEntity)heroUnit).f_19797_ % 20 == 0) {
            heroUnit.setMana(heroUnit.getMana() + heroUnit.getManaRegenPerSecond());
        }
    }

    public static ResourceCost getReviveCost(int heroLevel) {
        return ResourceCost.Unit(ResourceCosts.HERO_BASE_REVIVE_COST.food + Mth.m_14045_((int)heroLevel, (int)1, (int)10) * ResourceCosts.HERO_EXTRA_REVIVE_COST_PER_LEVEL.food, ResourceCosts.HERO_BASE_REVIVE_COST.wood + Mth.m_14045_((int)heroLevel, (int)1, (int)10) * ResourceCosts.HERO_EXTRA_REVIVE_COST_PER_LEVEL.wood, ResourceCosts.HERO_BASE_REVIVE_COST.ore + Mth.m_14045_((int)heroLevel, (int)1, (int)10) * ResourceCosts.HERO_EXTRA_REVIVE_COST_PER_LEVEL.ore, (ResourceCosts.HERO_BASE_REVIVE_COST.ticks + Mth.m_14045_((int)heroLevel, (int)1, (int)10) * ResourceCosts.HERO_EXTRA_REVIVE_COST_PER_LEVEL.ticks) / 20, ResourceCosts.HERO_BASE_REVIVE_COST.population);
    }

    public static List<HeroUnit> getHeroes(boolean isClientside) {
        ArrayList<LivingEntity> units = isClientside ? UnitClientEvents.getAllUnits() : UnitServerEvents.getAllUnits();
        return units.stream().filter(e -> e instanceof HeroUnit).map(e -> (HeroUnit)e).toList();
    }

    public static List<HeroUnit> getHeroes(boolean isClientside, String ownerName) {
        return HeroUnit.getHeroes(isClientside, ownerName, "");
    }

    public static List<HeroUnit> getHeroes(boolean isClientside, String ownerName, String unitName) {
        ArrayList<LivingEntity> units = isClientside ? UnitClientEvents.getAllUnits() : UnitServerEvents.getAllUnits();
        return units.stream().filter(e -> {
            HeroUnit heroUnit;
            return e instanceof HeroUnit && (heroUnit = (HeroUnit)e).getOwnerName().equals(ownerName) && (e.m_7755_().getString().equals(unitName) || unitName.isBlank());
        }).map(e -> (HeroUnit)e).toList();
    }

    @Nullable
    public static HeroUnitSave getFallenHero(boolean isClientSide, String ownerName, String heroName) {
        ArrayList<HeroUnitSave> heroUnits = isClientSide ? HeroClientEvents.fallenHeroes : HeroServerEvents.fallenHeroes;
        for (HeroUnitSave heroUnit : heroUnits) {
            if (!heroUnit.ownerName.equals(ownerName) || !heroUnit.name.equals(heroName)) continue;
            return heroUnit;
        }
        return null;
    }

    public float getHealthBonusPerLevel();

    public float getAttackBonusPerLevel();

    public float getBaseHealth();

    public float getBaseAttack();

    public float getBaseMaxMana();

    public float getMana();

    public void setMana(float var1);

    public float getMaxMana();

    public void setMaxMana(float var1);

    public float getManaRegenPerSecond();

    public float getManaBonusPerLevel();

    public int getSkillPoints();

    public void setSkillPoints(int var1);

    public boolean isRankUpMenuOpen();

    public void showRankUpMenu(boolean var1);

    public int getExperience();

    public void setExperience(int var1);

    default public int getChargesForSaveData() {
        return 0;
    }

    default public void setChargesFromSaveData(int charges) {
    }

    default public void setStatsForLevel() {
        this.setStatsForLevel(false);
    }

    default public void setStatsForLevel(boolean heal) {
        AttributeInstance aiAttackDamage;
        AttributeInstance aiMaxHealth = ((LivingEntity)this).m_21051_(Attributes.f_22276_);
        if (aiMaxHealth != null) {
            aiMaxHealth.m_22100_((double)(this.getBaseHealth() + (float)(this.getHeroLevel() - 1) * this.getHealthBonusPerLevel()));
        }
        if ((aiAttackDamage = ((LivingEntity)this).m_21051_(Attributes.f_22281_)) != null) {
            aiAttackDamage.m_22100_((double)(this.getBaseAttack() + (float)(this.getHeroLevel() - 1) * this.getAttackBonusPerLevel()));
        }
        this.setMaxMana(this.getBaseMaxMana() + (float)(this.getHeroLevel() - 1) * this.getManaBonusPerLevel());
        if (heal) {
            ((LivingEntity)this).m_21153_(((LivingEntity)this).m_21233_());
        }
    }

    default public void addExperience(int amount) {
        if (((LivingEntity)this).m_9236_().m_5776_()) {
            return;
        }
        int levelBefore = this.getHeroLevel();
        if (levelBefore >= 10) {
            return;
        }
        this.setExperience(this.getExperience() + amount);
        int levelDiff = this.getHeroLevel() - levelBefore;
        HeroClientboundPacket.setExperience(((LivingEntity)this).m_19879_(), this.getExperience());
        if (levelDiff > 0) {
            this.setSkillPoints(this.getSkillPoints() + levelDiff);
            HeroClientboundPacket.setSkillPoints(((LivingEntity)this).m_19879_(), this.getSkillPoints());
            SoundClientboundPacket.playSoundAtPos(SoundAction.LEVEL_UP, ((LivingEntity)this).m_20097_());
            this.setStatsForLevel();
            ((LivingEntity)this).m_5634_((float)levelDiff * this.getHealthBonusPerLevel());
        }
    }

    default public int getHeroLevel() {
        return HeroUnit.getHeroLevel(this.getExperience());
    }

    public static int getHeroLevel(int exp) {
        int level = 0;
        int expToNextLevel = 320;
        while ((exp -= (expToNextLevel = (int)((float)expToNextLevel + 160.0f))) >= 0 && ++level < 10) {
        }
        return level;
    }

    default public int getExpOnCurrentLevel() {
        if (this.getHeroLevel() >= 10) {
            return 0;
        }
        int expToNextLevel = 320;
        int exp = this.getExperience();
        for (int expCount = 0; expCount < exp; expCount += expToNextLevel) {
            if (expCount + expToNextLevel > exp) {
                return exp - expCount;
            }
            expToNextLevel = (int)((float)expToNextLevel + 160.0f);
        }
        return 0;
    }

    default public int getExpToNextlevel() {
        if (this.getHeroLevel() >= 10) {
            return 0;
        }
        return (int)((float)(this.getHeroLevel() + 1) * 160.0f);
    }

    default public List<HeroAbility> getHeroAbilities() {
        return this.getAbilities().get().stream().filter(a -> a instanceof HeroAbility).map(a -> (HeroAbility)a).toList();
    }

    default public void addHeroUnitSaveData(@NotNull CompoundTag pCompound) {
        pCompound.m_128405_("experience", this.getExperience());
        pCompound.m_128405_("skillPoints", this.getSkillPoints());
        pCompound.m_128405_("charges", this.getChargesForSaveData());
        pCompound.m_128350_("mana", this.getMana());
        pCompound.m_128350_("maxMana", this.getMaxMana());
        List<HeroAbility> abls = this.getHeroAbilities();
        pCompound.m_128405_("ability1Rank", abls.size() > 0 ? this.getHeroAbilityRank(abls.get(0)) : 0);
        pCompound.m_128405_("ability2Rank", abls.size() > 1 ? this.getHeroAbilityRank(abls.get(1)) : 0);
        pCompound.m_128405_("ability3Rank", abls.size() > 2 ? this.getHeroAbilityRank(abls.get(2)) : 0);
        pCompound.m_128405_("ability4Rank", abls.size() > 3 ? this.getHeroAbilityRank(abls.get(3)) : 0);
    }

    default public void readHeroUnitSaveData(@NotNull CompoundTag pCompound) {
        this.setExperience(pCompound.m_128451_("experience"));
        this.setSkillPoints(pCompound.m_128451_("skillPoints"));
        this.setChargesFromSaveData(pCompound.m_128451_("charges"));
        this.setMana(pCompound.m_128457_("mana"));
        this.setMaxMana(pCompound.m_128457_("maxMana"));
        List<HeroAbility> abls = this.getHeroAbilities();
        if (abls.size() > 0) {
            this.setHeroAbilityRank(abls.get(0), pCompound.m_128451_("ability1Rank"));
        }
        if (abls.size() > 1) {
            this.setHeroAbilityRank(abls.get(1), pCompound.m_128451_("ability2Rank"));
        }
        if (abls.size() > 2) {
            this.setHeroAbilityRank(abls.get(2), pCompound.m_128451_("ability3Rank"));
        }
        if (abls.size() > 3) {
            this.setHeroAbilityRank(abls.get(3), pCompound.m_128451_("ability4Rank"));
        }
        for (HeroAbility abl : abls) {
            abl.updateStatsForRank(this);
        }
    }

    default public void activateAbilityClientside(int abilityIndex) {
    }

    default public void deactivateAbilityClientside(int abilityIndex) {
    }

    default public int getHeroAbilityRank(HeroAbility ability) {
        return (Integer)this.getHeroAbilityRanks().getOrDefault((Object)ability, (Object)0);
    }

    default public void syncToClients() {
        Entity entity = (Entity)this;
        if (!entity.m_9236_().m_5776_()) {
            HeroClientboundPacket.setExperience(entity.m_19879_(), this.getExperience());
            HeroClientboundPacket.setSkillPoints(entity.m_19879_(), this.getSkillPoints());
            HeroClientboundPacket.setCharges(entity.m_19879_(), this.getChargesForSaveData());
            List<HeroAbility> abls = this.getHeroAbilities();
            if (abls.size() > 0) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get(0).getRank(this), 0);
            }
            if (abls.size() > 1) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get(1).getRank(this), 1);
            }
            if (abls.size() > 2) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get(2).getRank(this), 2);
            }
            if (abls.size() > 3) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get(3).getRank(this), 3);
            }
        }
    }

    default public void setHeroAbilityRank(HeroAbility ability, int rank) {
        this.getHeroAbilityRanks().put((Object)ability, (Object)rank);
    }

    public Object2ObjectArrayMap<HeroAbility, Integer> getHeroAbilityRanks();
}

