/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.modelling.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.interfaces.ArmSwingingUnit;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.MilitiaUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import java.util.List;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VillagerUnitModel<T extends AbstractIllager>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"villager_unit_layer"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart hatRim;
    private final ModelPart crossedArms;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    public boolean armsVisible = true;

    public void hatRimVisible(boolean pVisible) {
        this.hatRim.f_104207_ = pVisible;
    }

    public VillagerUnitModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.hat.f_104207_ = true;
        this.hatRim = this.hat.m_171324_("hat_rim");
        this.hatRim.f_104207_ = false;
        this.crossedArms = root.m_171324_("arms");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition3 = partdefinition1.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.f_171404_);
        partdefinition3.m_171599_("hat_rim", CubeListBuilder.m_171558_().m_171514_(30, 47).m_171481_(-8.0f, -8.0f, -6.0f, 16.0f, 16.0f, 1.0f), PartPose.m_171430_((float)-1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition1.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.f_171404_);
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ArmPose getArmPose(Entity entity) {
        WorkerUnit workerUnit;
        if (entity instanceof WorkerUnit && (workerUnit = (WorkerUnit)entity).getGatherResourceGoal() != null && workerUnit.getGatherResourceGoal().isGathering()) {
            return ArmPose.GATHERING;
        }
        if (entity instanceof WorkerUnit && (workerUnit = (WorkerUnit)entity).getBuildRepairGoal() != null && workerUnit.getBuildRepairGoal().isBuilding()) {
            return ArmPose.BUILDING;
        }
        if (entity instanceof EvokerUnit) {
            EvokerUnit evokerUnit = (EvokerUnit)entity;
            return evokerUnit.getEvokerArmPose();
        }
        if (entity instanceof PillagerUnit) {
            return ArmPose.CROSSBOW_CHARGE;
        }
        if (entity instanceof MilitiaUnit) {
            MilitiaUnit militiaUnit = (MilitiaUnit)entity;
            if (militiaUnit.isUsingBow()) {
                if (militiaUnit.m_5912_()) {
                    return ArmPose.BOW_AND_ARROW;
                }
                return ArmPose.CROSSBOW_CHARGE;
            }
            return ArmPose.ATTACKING;
        }
        if (entity instanceof AttackerUnit) {
            MeleeAttackBuildingGoal mabg;
            Goal goal;
            AttackerUnit attackerUnit = (AttackerUnit)entity;
            SelectedTargetGoal<?> goal2 = ((Unit)entity).getTargetGoal();
            if (goal2 != null && goal2.getTarget() != null || (goal = attackerUnit.getAttackBuildingGoal()) instanceof MeleeAttackBuildingGoal && (mabg = (MeleeAttackBuildingGoal)goal).getBuildingTarget() != null) {
                return ArmPose.ATTACKING;
            }
        }
        return ArmPose.CROSSED;
    }

    public void setupAnim(T entity, float p_102929_, float p_102930_, float p_102931_, float p_102932_, float p_102933_) {
        ArmSwingingUnit armSwinger;
        if (this.f_102609_) {
            this.rightArm.f_104203_ = -0.62831855f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -0.62831855f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(p_102929_ * 0.6662f + (float)Math.PI)) * 2.0f * p_102930_ * 0.5f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(p_102929_ * 0.6662f)) * 2.0f * p_102930_ * 0.5f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(p_102929_ * 0.6662f)) * 1.4f * p_102930_ * 0.5f;
            this.rightLeg.f_104204_ = 0.0f;
            this.rightLeg.f_104205_ = 0.0f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(p_102929_ * 0.6662f + (float)Math.PI)) * 1.4f * p_102930_ * 0.5f;
            this.leftLeg.f_104204_ = 0.0f;
            this.leftLeg.f_104205_ = 0.0f;
        }
        this.head.f_104204_ = p_102932_ * ((float)Math.PI / 180);
        this.head.f_104203_ = p_102933_ * ((float)Math.PI / 180);
        ArmPose armPose = this.getArmPose((Entity)entity);
        switch (armPose) {
            case ATTACKING: {
                if (entity.m_21205_().m_41619_()) {
                    AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.f_102608_, (float)p_102931_);
                    break;
                }
                AnimationUtils.m_102091_((ModelPart)this.rightArm, (ModelPart)this.leftArm, entity, (float)this.f_102608_, (float)p_102931_);
                break;
            }
            case SPELLCASTING: {
                this.rightArm.f_104202_ = 0.0f;
                this.rightArm.f_104200_ = -5.0f;
                this.leftArm.f_104202_ = 0.0f;
                this.leftArm.f_104200_ = 5.0f;
                this.rightArm.f_104203_ = Mth.m_14089_((float)(p_102931_ * 0.6662f)) * 0.25f;
                this.leftArm.f_104203_ = Mth.m_14089_((float)(p_102931_ * 0.6662f)) * 0.25f;
                this.rightArm.f_104205_ = 2.3561945f;
                this.leftArm.f_104205_ = -2.3561945f;
                this.rightArm.f_104204_ = 0.0f;
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.f_104204_ = -0.1f + this.head.f_104204_;
                this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                this.leftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
                this.leftArm.f_104204_ = this.head.f_104204_ - 0.4f;
                this.leftArm.f_104205_ = 1.5707964f;
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, entity, (boolean)true);
            }
        }
        boolean armsCrossed = armPose == ArmPose.CROSSED;
        this.crossedArms.f_104207_ = armsCrossed && this.armsVisible;
        this.leftArm.f_104207_ = !armsCrossed && this.armsVisible;
        boolean bl = this.rightArm.f_104207_ = !armsCrossed && this.armsVisible;
        if (entity instanceof ArmSwingingUnit && ((armSwinger = (ArmSwingingUnit)entity).isSwingingArmRepeatedly() || armSwinger.isSwingingArmOnce())) {
            List<Float> armRots = armSwinger.getNextArmRot();
            this.rightArm.f_104203_ = armRots.get(0).floatValue();
            this.rightArm.f_104204_ = armRots.get(1).floatValue();
            this.rightArm.f_104205_ = armRots.get(2).floatValue();
            int swingTime = armSwinger.getSwingTime();
            armSwinger.setSwingTime(swingTime + 1);
            if (swingTime >= 80) {
                armSwinger.setSwingTime(0);
                if (armSwinger.isSwingingArmOnce()) {
                    armSwinger.setSwingingArmOnce(false);
                }
            }
        }
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHat() {
        return this.hat;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.getArm(p_102925_).m_104299_(p_102926_);
    }

    public static enum ArmPose {
        CROSSED,
        ATTACKING,
        CROSSBOW_HOLD,
        CROSSBOW_CHARGE,
        BUILDING,
        GATHERING,
        SPELLCASTING,
        BOW_AND_ARROW;

    }
}

