/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.modelling.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.solegendary.reignofnether.unit.modelling.models.VillagerUnitModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.metadata.animation.VillagerMetaDataSection;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class VillagerUnitProfessionLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Int2ObjectMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), p_117657_ -> {
        p_117657_.put(1, (Object)ResourceLocation.parse((String)"stone"));
        p_117657_.put(2, (Object)ResourceLocation.parse((String)"iron"));
        p_117657_.put(3, (Object)ResourceLocation.parse((String)"gold"));
        p_117657_.put(4, (Object)ResourceLocation.parse((String)"emerald"));
        p_117657_.put(5, (Object)ResourceLocation.parse((String)"diamond"));
    });
    private final Object2ObjectMap<VillagerType, VillagerMetaDataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetaDataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ResourceManager resourceManager;
    private final String path;

    public VillagerUnitProfessionLayer(RenderLayerParent<T, M> pRenderer, ResourceManager pResourceManager, String pPath) {
        super(pRenderer);
        this.resourceManager = pResourceManager;
        this.path = pPath;
    }

    public void render(@NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!pLivingEntity.m_20145_()) {
            VillagerData vData = ((VillagerDataHolder)pLivingEntity).m_7141_();
            VillagerType biomeType = vData.m_35560_();
            VillagerProfession profession = vData.m_35571_();
            VillagerMetaDataSection.Hat typeHatData = this.getHatData(this.typeHatCache, "type", BuiltInRegistries.f_256934_, biomeType);
            VillagerMetaDataSection.Hat profHatData = this.getHatData(this.professionHatCache, "profession", BuiltInRegistries.f_256735_, profession);
            EntityModel vHeadModel = this.m_117386_();
            ((VillagerUnitModel)vHeadModel).hatRimVisible(profession == VillagerProfession.f_35590_);
            ResourceLocation biomeTypeRL = this.getResourceLocation("type", BuiltInRegistries.f_256934_.m_7981_((Object)biomeType));
            VillagerUnitProfessionLayer.m_117376_((EntityModel)vHeadModel, (ResourceLocation)biomeTypeRL, (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, pLivingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
            if (profession != VillagerProfession.f_35585_ && !pLivingEntity.m_6162_()) {
                ResourceLocation profRL = this.getResourceLocation("profession", BuiltInRegistries.f_256735_.m_7981_((Object)profession));
                VillagerUnitProfessionLayer.m_117376_((EntityModel)vHeadModel, (ResourceLocation)profRL, (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, pLivingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
                if (profession != VillagerProfession.f_35596_) {
                    ResourceLocation profLevelRL = this.getResourceLocation("profession_level", (ResourceLocation)LEVEL_LOCATIONS.get(Mth.m_14045_((int)vData.m_35576_(), (int)1, (int)LEVEL_LOCATIONS.size())));
                    VillagerUnitProfessionLayer.m_117376_((EntityModel)vHeadModel, (ResourceLocation)profLevelRL, (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pPackedLight, pLivingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            ((VillagerUnitModel)vHeadModel).hatRimVisible(false);
        }
    }

    private ResourceLocation getResourceLocation(String p_117669_, ResourceLocation p_117670_) {
        return ResourceLocation.fromNamespaceAndPath((String)p_117670_.m_135827_(), (String)("textures/entity/" + this.path + "/" + p_117669_ + "/" + p_117670_.m_135815_() + ".png"));
    }

    public <K> VillagerMetaDataSection.Hat getHatData(Object2ObjectMap<K, VillagerMetaDataSection.Hat> p_117659_, String p_117660_, DefaultedRegistry<K> p_117661_, K p_117662_) {
        return (VillagerMetaDataSection.Hat)p_117659_.computeIfAbsent(p_117662_, p_234880_ -> this.resourceManager.m_213713_(this.getResourceLocation(p_117660_, p_117661_.m_7981_(p_117662_))).flatMap(p_234875_ -> {
            try {
                return p_234875_.m_215509_().m_214059_((MetadataSectionSerializer)VillagerMetaDataSection.f_119065_).map(VillagerMetaDataSection::m_119070_);
            }
            catch (IOException var2) {
                return Optional.empty();
            }
        }).orElse(VillagerMetaDataSection.Hat.NONE));
    }
}

