/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitSyncAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitSyncAbilityClientboundPacket {
    private final UnitSyncAction syncAction;
    private final int entityId;
    private final int[] abilityCooldowns;
    private final int[] abilityCharges;

    public static void sendSyncAbilitiesPacket(LivingEntity entity) {
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncAbilityClientboundPacket(UnitSyncAction.SYNC_ABILITIES, entity.m_19879_(), unit.getAbilities().get().stream().mapToInt(a -> (int)a.getCooldown(unit)).toArray(), unit.getAbilities().get().stream().mapToInt(a -> a.getCharges(unit)).toArray()));
        }
    }

    public UnitSyncAbilityClientboundPacket(UnitSyncAction syncAction, int entityId, int[] abilityCooldowns, int[] abilityCharges) {
        this.syncAction = syncAction;
        this.entityId = entityId;
        this.abilityCooldowns = abilityCooldowns;
        this.abilityCharges = abilityCharges;
    }

    public UnitSyncAbilityClientboundPacket(FriendlyByteBuf buffer) {
        this.syncAction = (UnitSyncAction)buffer.m_130066_(UnitSyncAction.class);
        this.entityId = buffer.readInt();
        this.abilityCooldowns = buffer.m_130100_();
        this.abilityCharges = buffer.m_130100_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.syncAction);
        buffer.writeInt(this.entityId);
        buffer.m_130089_(this.abilityCooldowns);
        buffer.m_130089_(this.abilityCharges);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            block0 : switch (this.syncAction) {
                case SYNC_ABILITIES: {
                    for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                        if (entity.m_19879_() != this.entityId || !(entity instanceof Unit)) continue;
                        Unit unit = (Unit)entity;
                        for (int i = 0; i < unit.getAbilities().get().size(); ++i) {
                            if (this.abilityCooldowns.length > i) {
                                unit.getAbilities().get().get(i).setCooldown(this.abilityCooldowns[i], false, unit);
                            }
                            if (this.abilityCharges.length <= i) continue;
                            unit.getAbilities().get().get(i).setCharges(unit, this.abilityCharges[i]);
                        }
                        unit.updateAbilityButtons();
                        break block0;
                    }
                    break;
                }
            }
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

