/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.packets;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitSyncAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitSyncClientboundPacket {
    private final UnitSyncAction syncAction;
    private final int entityId;
    private final int targetId;
    private final float health;
    private final float absorb;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int food;
    private final int wood;
    private final int ore;
    private final String ownerName;

    public static void sendLeavePacket(LivingEntity entity) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.LEAVE_LEVEL, entity.m_19879_(), 0, 0.0f, 0.0f, 0.0, 0.0, 0.0, 0, 0, 0, ""));
    }

    public static void sendSyncOwnerNamePacket(Unit unit) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.SYNC_OWNERNAME, ((LivingEntity)unit).m_19879_(), 0, 0.0f, 0.0f, 0.0, 0.0, 0.0, 0, 0, 0, unit.getOwnerName()));
    }

    public static void sendSyncStatsPacket(LivingEntity entity) {
        boolean isBuilding = false;
        ResourceName gatherTarget = ResourceName.NONE;
        String owner = "";
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            owner = unit.getOwnerName();
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.SYNC_STATS, entity.m_19879_(), 0, entity.m_21223_(), entity.m_6103_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0, 0, 0, owner));
    }

    public static void sendSyncResourcesPacket(Unit unit) {
        Resources res = Resources.getTotalResourcesFromItems(unit.getItems());
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.SYNC_RESOURCES, ((LivingEntity)unit).m_19879_(), 0, 0.0f, 0.0f, 0.0, 0.0, 0.0, res.food, res.wood, res.ore, ""));
    }

    public static void makeVillagerVeteran(LivingEntity entity) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.MAKE_VILLAGER_VETERAN, entity.m_19879_(), 0, 0.0f, 0.0f, 0.0, 0.0, 0.0, 0, 0, 0, ""));
    }

    public static void sendSyncAnchorPosPacket(LivingEntity entity, BlockPos bp) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.SYNC_ANCHOR_POS, entity.m_19879_(), 0, 0.0f, 0.0f, bp.m_123341_(), bp.m_123342_(), bp.m_123343_(), 0, 0, 0, ""));
    }

    public static void sendRemoveAnchorPosPacket(LivingEntity entity) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UnitSyncClientboundPacket(UnitSyncAction.SYNC_ANCHOR_POS, entity.m_19879_(), 0, 0.0f, 0.0f, 0.0, 0.0, 0.0, 0, 0, 0, ""));
    }

    public UnitSyncClientboundPacket(UnitSyncAction syncAction, int unitId, int targetId, float health, float absorb, double posX, double posY, double posZ, int food, int wood, int ore, String ownerName) {
        this.syncAction = syncAction;
        this.entityId = unitId;
        this.targetId = targetId;
        this.health = health;
        this.absorb = absorb;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.food = food;
        this.wood = wood;
        this.ore = ore;
        this.ownerName = ownerName;
    }

    public UnitSyncClientboundPacket(FriendlyByteBuf buffer) {
        this.syncAction = (UnitSyncAction)buffer.m_130066_(UnitSyncAction.class);
        this.entityId = buffer.readInt();
        this.targetId = buffer.readInt();
        this.health = buffer.readFloat();
        this.absorb = buffer.readFloat();
        this.posX = buffer.readDouble();
        this.posY = buffer.readDouble();
        this.posZ = buffer.readDouble();
        this.food = buffer.readInt();
        this.wood = buffer.readInt();
        this.ore = buffer.readInt();
        this.ownerName = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.syncAction);
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.targetId);
        buffer.writeFloat(this.health);
        buffer.writeFloat(this.absorb);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
        buffer.writeInt(this.food);
        buffer.writeInt(this.wood);
        buffer.writeInt(this.ore);
        buffer.m_130070_(this.ownerName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.syncAction) {
                case LEAVE_LEVEL: {
                    UnitClientEvents.onEntityLeave(this.entityId);
                    break;
                }
                case SYNC_OWNERNAME: {
                    UnitClientEvents.syncOwnerName(this.entityId, this.ownerName);
                    break;
                }
                case SYNC_STATS: {
                    UnitClientEvents.syncUnitStats(this.entityId, this.health, this.absorb, new Vec3(this.posX, this.posY, this.posZ), this.ownerName);
                    break;
                }
                case SYNC_RESOURCES: {
                    UnitClientEvents.syncUnitResources(this.entityId, new Resources("", this.food, this.wood, this.ore));
                    break;
                }
                case MAKE_VILLAGER_VETERAN: {
                    UnitClientEvents.makeVillagerVeteran(this.entityId);
                    break;
                }
                case SYNC_ANCHOR_POS: {
                    UnitClientEvents.syncAnchorPos(this.entityId, new BlockPos((int)this.posX, (int)this.posY, (int)this.posZ));
                    break;
                }
                case REMOVE_ANCHOR_POS: {
                    UnitClientEvents.removeAnchorPos(this.entityId);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

