/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.villagers;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.BackToWorkUnit;
import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.ability.abilities.WeaponSwapBow;
import com.solegendary.reignofnether.ability.abilities.WeaponSwapSword;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.villagers.TownCentre;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.TargetResourcesSave;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.BuildRepairGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.unit.packets.UnitConvertClientboundPacket;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class MilitiaUnit
extends Vindicator
implements Unit,
AttackerUnit,
RangedAttackerUnit,
VillagerDataHolder,
ConvertableUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private UnitBowAttackGoal<? extends LivingEntity> rangedAttackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    public boolean converted = false;
    private boolean shouldDiscard = false;
    public int fogRevealDuration = 0;
    public TargetResourcesSave resourcesSaveData = null;
    public VillagerProfession profession = VillagerProfession.f_35585_;
    public boolean isVeteran = false;
    public int farmerExp = 0;
    public int lumberjackExp = 0;
    public int minerExp = 0;
    public int masonExp = 0;
    public int hunterExp = 0;
    public static final float attackDamage = 3.0f;
    public static final float rangedAttackDamage = 3.0f;
    public static final float attacksPerSecond = 0.5f;
    public static final float rangedAttacksPerSecond = 0.3f;
    public static final float attackRange = 10.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public static final float maxHealth = 30.0f;
    public static final float armorValue = 5.5f;
    public static final float rangedArmorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float rangedMovementSpeed = 0.25f;
    public int maxResources = 100;
    public boolean isCaptain = false;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private static final EntityDataAccessor<VillagerData> VILLAGER_DATA;

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    public BuildRepairGoal getBuildRepairGoal() {
        return null;
    }

    public GatherResourcesGoal getGatherResourceGoal() {
        return null;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    @Override
    public float getMovementSpeed() {
        return this.isUsingBow() ? 0.25f : 0.28f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 30.0f;
    }

    @Override
    public ResourceCost getCost() {
        return ResourceCosts.MILITIA;
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return (int)(20.0f / (this.isUsingBow() ? 0.3f : 0.5f));
    }

    @Override
    public float getAttacksPerSecond() {
        return this.isUsingBow() ? 0.3f : 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return this.isUsingBow() ? 10.0f : 2.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return this.isUsingBow() ? 3.0f : 3.0f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null && !this.isUsingBow();
    }

    @Override
    public Goal getAttackGoal() {
        return this.isUsingBow() ? this.rangedAttackGoal : this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public boolean shouldDiscard() {
        return this.shouldDiscard;
    }

    @Override
    public void setShouldDiscard(boolean discard) {
        this.shouldDiscard = discard;
    }

    @Override
    public int getFogRevealDuration() {
        return this.fogRevealDuration;
    }

    @Override
    public void setFogRevealDuration(int duration) {
        this.fogRevealDuration = duration;
    }

    public MilitiaUnit(EntityType<? extends Vindicator> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    public boolean isUsingBow() {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42411_);
    }

    public void swapWeapons(boolean useBow) {
        AttributeInstance ai3;
        AttributeInstance ai2;
        Item weapon = useBow ? Items.f_42411_ : Items.f_42425_;
        boolean damageMod = false;
        ItemStack weaponStack = new ItemStack((ItemLike)weapon);
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), (double)damageMod, AttributeModifier.Operation.ADDITION);
        weaponStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
        this.m_8061_(EquipmentSlot.MAINHAND, weaponStack);
        AttributeInstance ai1 = this.m_21051_(Attributes.f_22281_);
        if (ai1 != null) {
            ai1.m_22100_(useBow ? 3.0 : 3.0);
        }
        if ((ai2 = this.m_21051_(Attributes.f_22279_)) != null) {
            ai2.m_22100_(useBow ? 0.25 : (double)0.28f);
        }
        if ((ai3 = this.m_21051_(Attributes.f_22284_)) != null) {
            ai3.m_22100_(useBow ? 0.0 : 5.5);
        }
        if (this.rangedAttackGoal != null && this.attackGoal != null) {
            if (useBow) {
                this.f_21345_.m_25363_((Goal)this.attackGoal);
                this.f_21345_.m_25352_(2, this.rangedAttackGoal);
            } else {
                this.f_21345_.m_25363_(this.rangedAttackGoal);
                this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
            }
        }
    }

    public boolean m_6785_(double d) {
        return false;
    }

    @Override
    public void setUnitAttackTarget(@Nullable LivingEntity target) {
        AttackerUnit.super.setUnitAttackTarget(target);
        if (!this.m_9236_().m_5776_()) {
            if (target != null) {
                UnitAnimationClientboundPacket.sendEntityPacket(UnitAnimationAction.NON_KEYFRAME_START, (LivingEntity)this, target);
            } else {
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_STOP, (LivingEntity)this);
            }
        }
    }

    @Override
    public void setAttackBuildingTarget(BlockPos preselectedBlockPos) {
        AttackerUnit.super.setAttackBuildingTarget(preselectedBlockPos);
        if (!this.m_9236_().m_5776_()) {
            UnitAnimationClientboundPacket.sendBlockPosPacket(UnitAnimationAction.NON_KEYFRAME_START, (LivingEntity)this, preselectedBlockPos);
        }
    }

    @Override
    public void resetBehaviours() {
        if (!this.m_9236_().m_5776_()) {
            UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_STOP, (LivingEntity)this);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 5.5);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    protected SoundEvent m_7975_(DamageSource p_34103_) {
        return SoundEvents.f_12506_;
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    public void m_8119_() {
        if (this.shouldDiscard) {
            this.m_146870_();
        } else {
            this.m_21553_(true);
            super.m_8119_();
            Unit.tick(this);
            AttackerUnit.tick(this);
            PromoteIllager.checkAndApplyBuff((LivingEntity)this);
            this.isCaptain = this.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem;
            if (!(this.isCaptain || this.f_19797_ <= 100 || this.f_19797_ % 10 != 0 || this.converted || this.m_9236_().m_5776_() || this.getOwnerName().equals("Enemy"))) {
                BuildingPlacement building = BuildingUtils.findClosestBuilding(this.m_9236_().m_5776_(), this.m_146892_(), b -> b.isBuilt && b.ownerName.equals(this.getOwnerName()) && b.getBuilding() instanceof TownCentre);
                int range = 60;
                if (building != null && this.m_20275_(building.centrePos.m_123341_(), building.centrePos.m_123342_(), building.centrePos.m_123343_()) > (double)(range * range)) {
                    this.convertToVillager();
                }
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    public void convertToVillager() {
        LivingEntity newEntity;
        if (!this.converted && (newEntity = this.convertToUnit((EntityType)EntityRegistrar.VILLAGER_UNIT.get())) instanceof VillagerUnit) {
            VillagerUnit vUnit = (VillagerUnit)newEntity;
            if (this.resourcesSaveData != null) {
                vUnit.getGatherResourceGoal().saveData = this.resourcesSaveData;
                vUnit.getGatherResourceGoal().loadState();
            }
            vUnit.setProfession(this.profession);
            vUnit.isVeteran = this.isVeteran;
            vUnit.farmerExp = this.farmerExp;
            vUnit.lumberjackExp = this.lumberjackExp;
            vUnit.minerExp = this.minerExp;
            vUnit.masonExp = this.masonExp;
            vUnit.hunterExp = this.hunterExp;
            UnitConvertClientboundPacket.syncConvertedUnits(this.getOwnerName(), List.of(Integer.valueOf(this.m_19879_())), List.of(Integer.valueOf(newEntity.m_19879_())));
            this.converted = true;
        }
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, true);
        this.rangedAttackGoal = new UnitBowAttackGoal<MilitiaUnit>(this);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
        ItemStack swordStack = new ItemStack((ItemLike)Items.f_42425_);
        this.m_8061_(EquipmentSlot.MAINHAND, swordStack);
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        Item sword = Items.f_42425_;
        boolean damageMod = false;
        ItemStack swordStack = new ItemStack((ItemLike)sword);
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), (double)damageMod, AttributeModifier.Operation.ADDITION);
        swordStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
        this.m_8061_(EquipmentSlot.MAINHAND, swordStack);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    @Override
    public void performUnitRangedAttack(LivingEntity pTarget, float velocity) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, velocity);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (pTarget.m_20192_() <= 1.0f) {
            d1 -= (double)(1.0f - pTarget.m_20192_());
        }
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
        this.m_5496_(SoundEvents.f_12382_, 3.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
        if (!this.m_9236_().m_5776_() && pTarget instanceof Unit) {
            Unit unit = (Unit)pTarget;
            FogOfWarClientboundPacket.revealRangedUnit(unit.getOwnerName(), this.m_19879_());
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
        this.f_19804_.m_135372_(VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35586_, 1));
    }

    public VillagerData m_7141_() {
        return (VillagerData)this.f_19804_.m_135370_(VILLAGER_DATA);
    }

    public void m_34375_(VillagerData p_35437_) {
        VillagerData villagerdata = this.m_7141_();
        this.f_19804_.m_135381_(VILLAGER_DATA, (Object)p_35437_);
    }

    static {
        ABILITIES.add(new BackToWorkUnit(), Keybindings.build);
        ABILITIES.add(new WeaponSwapBow(), Keybindings.keyQ);
        ABILITIES.add(new WeaponSwapSword(), Keybindings.keyQ);
        ownerDataAccessor = SynchedEntityData.m_135353_(MilitiaUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        VILLAGER_DATA = SynchedEntityData.m_135353_(Villager.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);
    }
}

