/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.villagers;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.Eject;
import com.solegendary.reignofnether.ability.abilities.Roar;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class RavagerUnit
extends Ravager
implements Unit,
AttackerUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    public static final float attackDamage = 7.0f;
    public static final float attacksPerSecond = 0.6f;
    public static final float maxHealth = 250.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.25f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public static final float ROAR_DAMAGE = 8.0f;
    public static final float ROAR_RANGE = 4.0f;
    public static final float ROAR_KNOCKBACK = 6.0f;
    public static final int ROAR_SLOW_DURATION = 200;
    private static final Predicate<Entity> NO_RAVAGER_AND_ALIVE;

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 33;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.6f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.25f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 7.0f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 250.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.RAVAGER;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    public RavagerUnit(EntityType<? extends Ravager> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    protected void m_8022_() {
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange());
    }

    protected void m_6731_(LivingEntity pEntity) {
    }

    public void m_8119_() {
        this.m_21553_(false);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, false);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    private void strongKnockback(Entity pEntity) {
        double d0 = pEntity.m_20185_() - this.m_20185_();
        double d1 = pEntity.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        pEntity.m_5997_(d0 / d2 * 6.0, 0.2, d1 / d2 * 6.0);
    }

    public void startToRoar() {
        this.m_5496_(SoundEvents.f_12363_, 3.0f, 1.0f);
        this.f_33322_ = 40;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        }
    }

    public void m_33368_() {
        if (this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                List<Mob> nearbyMobs = MiscUtil.getEntitiesWithinRange(new Vector3d(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_), 4.0f, Mob.class, this.m_9236_());
                for (Mob mob : nearbyMobs) {
                    if (!(mob instanceof Unit)) continue;
                    Unit unit = (Unit)mob;
                    if (UnitServerEvents.getUnitToEntityRelationship(this, (Entity)mob) == Relationship.FRIENDLY) continue;
                    this.strongKnockback((Entity)mob);
                    mob.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
                }
                HashSet<BuildingPlacement> affectedBuildings = new HashSet<BuildingPlacement>();
                for (double x = this.m_20182_().f_82479_ - 4.0; x < this.m_20182_().f_82479_ + 4.0; x += 1.0) {
                    for (double y = this.m_20182_().f_82480_ - 4.0; y < this.m_20182_().f_82480_ + 4.0; y += 1.0) {
                        for (double z = this.m_20182_().f_82481_ - 4.0; z < this.m_20182_().f_82481_ + 4.0; z += 1.0) {
                            BlockPos bp = new BlockPos((int)x, (int)y, (int)z);
                            BuildingPlacement building = BuildingUtils.findBuilding(false, bp);
                            if (building == null || building.ownerName.equals(this.getOwnerName())) continue;
                            affectedBuildings.add(building);
                        }
                    }
                }
                for (BuildingPlacement building : affectedBuildings) {
                    building.destroyRandomBlocks(8);
                }
                Vec3 vec3 = this.m_20191_().m_82399_();
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
                this.m_146850_(GameEvent.f_223709_);
                this.m_9236_().m_254877_(null, null, null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 2.0f, false, Level.ExplosionInteraction.NONE);
            } else {
                Vec3 vec3 = this.m_20191_().m_82399_();
                for (int i = 0; i < 80; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.2;
                    double d1 = this.f_19796_.m_188583_() * 0.2;
                    double d2 = this.f_19796_.m_188583_() * 0.2;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, d0, d1, d2);
                }
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
            }
        }
    }

    static {
        ABILITIES.add(new Roar(), Keybindings.keyQ);
        ABILITIES.add(new Eject(), Keybindings.keyW);
        ownerDataAccessor = SynchedEntityData.m_135353_(RavagerUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        NO_RAVAGER_AND_ALIVE = e -> e.m_6084_() && !(e instanceof Ravager);
    }
}

