/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.villagers;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.ability.heroAbilities.villager.Avatar;
import com.solegendary.reignofnether.ability.heroAbilities.villager.BattleRagePassive;
import com.solegendary.reignofnether.ability.heroAbilities.villager.MaceSlam;
import com.solegendary.reignofnether.ability.heroAbilities.villager.TauntingCry;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.registrars.MobEffectRegistrar;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.modelling.animations.RoyalGuardAnimations;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RoyalGuardUnit
extends Vindicator
implements AttackerUnit,
HeroUnit,
KeyframeAnimated {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Object2ObjectArrayMap<HeroAbility, Integer> heroAbilityRanks = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private GenericUntargetedSpellGoal castTauntingCryGoal;
    private GenericTargetedSpellGoal castMaceSlamGoal;
    private GenericUntargetedSpellGoal castAvatarGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    private int skillPoints = 1;
    private int experience = 0;
    private boolean rankUpMenuOpen = false;
    private float baseMaxMana;
    private float maxMana;
    private float mana = this.maxMana = (this.baseMaxMana = 100.0f);
    private float manaRegenPerSecond = 0.5f;
    private float manaBonusPerLevel = 6.0f;
    public static final float attackDamage = 6.0f;
    public static final float attackBonusPerLevel = 0.6f;
    public static final float attacksPerSecond = 0.5f;
    public static final float maxHealth = 125.0f;
    public static final float maxHealthBonusPerLevel = 15.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public final AnimationState idleAnimState = new AnimationState();
    public final AnimationState walkAnimState = new AnimationState();
    public final AnimationState spellChargeAnimState = new AnimationState();
    public final AnimationState spellActivateAnimState = new AnimationState();
    public final AnimationState attackAnimState = new AnimationState();
    private static final int ATTACK_WINDUP_TICKS = 12;
    public int tauntingCryTicksLeft = 0;
    public boolean avatarScalingStarted = false;
    public int avatarTicksLeft = 0;
    public int avatarScaleTicks = 0;
    public final int AVATAR_SCALE_TICKS_MAX = 40;
    private final float AVATAR_MAX_BONUS_SCALE = 0.6f;
    private static final double KNOCKBACK_RESISTANCE = 0.5;
    public AnimationDefinition activeAnimDef = null;
    public AnimationState activeAnimState = null;
    public int animateTicks = 0;
    public float animateScale = 1.0f;
    public boolean animateScaleReducing = false;

    @Override
    public Object2ObjectArrayMap<HeroAbility, Integer> getHeroAbilityRanks() {
        return this.heroAbilityRanks;
    }

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public GenericUntargetedSpellGoal getCastTauntingCryGoal() {
        return this.castTauntingCryGoal;
    }

    public GenericTargetedSpellGoal getCastMaceSlamGoal() {
        return this.castMaceSlamGoal;
    }

    public GenericUntargetedSpellGoal getCastAvatarGoal() {
        return this.castAvatarGoal;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 40;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 6.0f + 0.6f * (float)this.getHeroLevel();
    }

    @Override
    public float getUnitMaxHealth() {
        return 125.0f + 15.0f * (float)this.getHeroLevel();
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.ROYAL_GUARD;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int points) {
        this.skillPoints = points;
    }

    @Override
    public boolean isRankUpMenuOpen() {
        return this.rankUpMenuOpen;
    }

    @Override
    public void showRankUpMenu(boolean show) {
        this.rankUpMenuOpen = show;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    @Override
    public void setExperience(int amount) {
        this.experience = amount;
        this.setStatsForLevel();
    }

    @Override
    public float getBaseMaxMana() {
        return this.baseMaxMana;
    }

    @Override
    public float getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMaxMana(float amount) {
        this.maxMana = amount;
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.setMaxMana(this.m_19879_(), amount);
        }
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public void setMana(float amount) {
        this.mana = Math.min(this.maxMana, amount);
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.setMana(this.m_19879_(), this.mana);
        }
    }

    @Override
    public float getManaRegenPerSecond() {
        return this.manaRegenPerSecond;
    }

    @Override
    public float getManaBonusPerLevel() {
        return this.manaBonusPerLevel;
    }

    @Override
    public float getHealthBonusPerLevel() {
        return 15.0f;
    }

    @Override
    public float getAttackBonusPerLevel() {
        return 0.6f;
    }

    @Override
    public float getBaseHealth() {
        return 125.0f;
    }

    @Override
    public float getBaseAttack() {
        return 6.0f;
    }

    @Override
    public void stopAllAnimations() {
        this.idleAnimState.m_216973_();
        this.walkAnimState.m_216973_();
        this.spellChargeAnimState.m_216973_();
        this.spellActivateAnimState.m_216973_();
        this.attackAnimState.m_216973_();
    }

    @Override
    public void setAnimateTicksLeft(int ticks) {
        this.animateTicks = ticks;
    }

    @Override
    public int getAnimateTicksLeft() {
        return this.animateTicks;
    }

    @Override
    public void playSingleAnimation(UnitAnimationAction animAction) {
        this.animateScaleReducing = false;
        switch (animAction) {
            case ATTACK_UNIT: 
            case ATTACK_BUILDING: {
                this.activeAnimDef = RoyalGuardAnimations.ATTACK;
                this.activeAnimState = this.attackAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case CHARGE_SPELL: {
                this.activeAnimDef = RoyalGuardAnimations.SPELL_CHARGE;
                this.activeAnimState = this.spellChargeAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case CAST_SPELL: {
                this.activeAnimDef = RoyalGuardAnimations.SPELL_ACTIVATE;
                this.activeAnimState = this.spellActivateAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            default: {
                this.animateScaleReducing = true;
            }
        }
    }

    public RoyalGuardUnit(EntityType<? extends Vindicator> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
        this.setStatsForLevel();
    }

    public float m_6515_(DamageSource pSource, float pDamage) {
        pDamage = super.m_6515_(pSource, pDamage);
        if (pSource.m_269533_(DamageTypeTags.f_268731_)) {
            pDamage *= 0.7f;
        }
        return pDamage;
    }

    @Override
    public void setStatsForLevel(boolean heal) {
        AttributeInstance aiAttackDamage;
        AttributeInstance aiMaxHealth = this.m_21051_(Attributes.f_22276_);
        float newHealth = this.getBaseHealth() + (float)(this.getHeroLevel() - 1) * this.getHealthBonusPerLevel();
        if (this.avatarTicksLeft > 0) {
            newHealth += 100.0f;
        }
        if (aiMaxHealth != null) {
            aiMaxHealth.m_22100_((double)newHealth);
        }
        if ((aiAttackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            aiAttackDamage.m_22100_((double)(this.getBaseAttack() + (float)(this.getHeroLevel() - 1) * this.getAttackBonusPerLevel()));
        }
        this.setMaxMana(this.getBaseMaxMana() + (float)(this.getHeroLevel() - 1) * this.getManaBonusPerLevel());
        if (heal) {
            this.m_21153_(this.m_21233_());
        }
        if (this.m_21223_() > this.m_21233_()) {
            this.m_21153_(this.m_21233_());
        }
    }

    private void updateKnockbackResistance() {
        AttributeInstance ai = this.m_21051_(Attributes.f_22278_);
        if (ai != null) {
            if (this.avatarTicksLeft > 0 || this.tauntingCryTicksLeft > 0) {
                ai.m_22100_(0.5);
            } else {
                ai.m_22100_(0.5);
            }
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        if (this.tauntingCryTicksLeft > 0) {
            pAmount *= 0.5f;
        }
        boolean result = super.m_6469_(pSource, pAmount);
        BattleRagePassive battleRage = this.getBattleRage();
        if (result && battleRage.getRank(this) > 0 && (entity = pSource.m_7639_()) instanceof Unit) {
            Unit unit = (Unit)entity;
            if (!List.of(Relationship.OWNED, Relationship.FRIENDLY).contains((Object)UnitServerEvents.getUnitToEntityRelationship(unit, (Entity)this))) {
                this.setMana(this.mana + pAmount * battleRage.manaPerDmgTaken);
            }
        }
        return result;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean result = super.m_7327_(pEntity);
        if (result && this.avatarTicksLeft > 0) {
            List<LivingEntity> hitEntities = MiscUtil.getEntitiesWithinRange(pEntity.m_146892_(), 2.5f, LivingEntity.class, this.m_9236_()).stream().filter(e -> {
                if (e instanceof Unit) {
                    Unit unit = (Unit)e;
                    return !List.of(Relationship.OWNED, Relationship.FRIENDLY).contains((Object)UnitServerEvents.getUnitToEntityRelationship(unit, (Entity)this));
                }
                return true;
            }).toList();
            this.m_9236_().m_254877_(null, null, null, pEntity.m_20185_(), pEntity.m_20186_(), pEntity.m_20189_(), 1.0f, false, Level.ExplosionInteraction.NONE);
            AttributeInstance ai = this.m_21051_(Attributes.f_22281_);
            if (ai != null) {
                for (LivingEntity hitEntity : hitEntities) {
                    boolean hurt;
                    if (hitEntity == pEntity || !(hurt = hitEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)ai.m_22135_() * 0.5f))) continue;
                    float kb = (float)this.m_21133_(Attributes.f_22282_);
                    hitEntity.m_147240_((double)(kb * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                    this.m_21335_((Entity)hitEntity);
                }
            }
        }
        return result;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22276_, 125.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange());
    }

    public void m_8119_() {
        BlockPos maceSlamBp;
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        HeroUnit.tick(this);
        PromoteIllager.checkAndApplyBuff((LivingEntity)this);
        if (this.m_9236_().m_5776_() && this.animateTicks > 0) {
            --this.animateTicks;
        }
        this.castMaceSlamGoal.m_8037_();
        this.castTauntingCryGoal.m_8037_();
        this.castAvatarGoal.m_8037_();
        this.tickTauntingCry();
        this.tickBattleRage();
        this.tickAvatar();
        if (this.f_19797_ % 100 == 0) {
            this.updateKnockbackResistance();
        }
        if ((maceSlamBp = this.castMaceSlamGoal.getCastTarget()) != null && this.m_20238_(Vec3.m_82512_((Vec3i)maceSlamBp)) < 3.0) {
            double x0 = (double)maceSlamBp.m_123341_() - this.m_20185_();
            double z0 = (double)maceSlamBp.m_123343_() - this.m_20189_();
            float f = (float)(Mth.m_14136_((double)z0, (double)x0) * 57.2957763671875) - 90.0f;
            this.m_146922_(this.rotlerp(this.m_146908_(), f, 10.0f));
        } else if (this.m_5448_() != null && this.m_20238_(this.m_5448_().m_20182_()) < 3.0) {
            double x0 = this.m_5448_().m_20185_() - this.m_20185_();
            double z0 = this.m_5448_().m_20189_() - this.m_20189_();
            float f = (float)(Mth.m_14136_((double)z0, (double)x0) * 57.2957763671875) - 90.0f;
            this.m_146922_(this.rotlerp(this.m_146908_(), f, 10.0f));
        }
    }

    private float rotlerp(float pAngle, float pTargetAngle, float pMaxIncrease) {
        float f = Mth.m_14177_((float)(pTargetAngle - pAngle));
        if (f > pMaxIncrease) {
            f = pMaxIncrease;
        }
        if (f < -pMaxIncrease) {
            f = -pMaxIncrease;
        }
        return pAngle + f;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    public MaceSlam getMaceSlam() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof MaceSlam)) continue;
            return (MaceSlam)ability;
        }
        return null;
    }

    public TauntingCry getTauntingCry() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof TauntingCry)) continue;
            return (TauntingCry)ability;
        }
        return null;
    }

    public BattleRagePassive getBattleRage() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof BattleRagePassive)) continue;
            return (BattleRagePassive)ability;
        }
        return null;
    }

    public Avatar getAvatar() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof Avatar)) continue;
            return (Avatar)ability;
        }
        return null;
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeWindupAttackUnitGoal((Mob)this, false, 12);
        this.attackBuildingGoal = new MeleeWindupAttackBuildingGoal((Mob)this, 12);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.castMaceSlamGoal = new GenericTargetedSpellGoal((Mob)this, 14, 3.0f, UnitAnimationAction.ATTACK_UNIT, null, this::maceSlam, null);
        this.castTauntingCryGoal = new GenericUntargetedSpellGoal((LivingEntity)this, 0, this::tauntingCry, null, UnitAnimationAction.STOP, UnitAnimationAction.CAST_SPELL);
        this.castAvatarGoal = new GenericUntargetedSpellGoal((LivingEntity)this, 40, this::enableAvatar, UnitAnimationAction.CHARGE_SPELL, UnitAnimationAction.STOP, null);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21346_.m_25352_(3, (Goal)this.moveGoal);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    @Override
    public void resetBehaviours() {
        this.animateScaleReducing = true;
        this.castMaceSlamGoal.m_8041_();
        this.castTauntingCryGoal.m_8041_();
        this.castAvatarGoal.m_8041_();
        if (this.avatarTicksLeft <= 0 && this.avatarScalingStarted) {
            this.disableAvatar();
            this.updateKnockbackResistance();
        }
    }

    public void maceSlam(BlockPos blockPos) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List<LivingEntity> hitEntities = MiscUtil.getEntitiesWithinRange(Vec3.m_82512_((Vec3i)blockPos.m_7494_()), 3.0f, LivingEntity.class, this.m_9236_()).stream().filter(e -> {
            if (e instanceof Unit) {
                Unit unit = (Unit)e;
                return !List.of(Relationship.OWNED, Relationship.FRIENDLY).contains((Object)UnitServerEvents.getUnitToEntityRelationship(unit, (Entity)this));
            }
            return true;
        }).toList();
        MaceSlam maceSlam = this.getMaceSlam();
        if (maceSlam != null && maceSlam.getRank(this) > 0) {
            this.m_9236_().m_254877_(null, null, null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 2.0f, false, Level.ExplosionInteraction.NONE);
            HashSet<BuildingPlacement> buildings = new HashSet<BuildingPlacement>();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BuildingPlacement building = BuildingUtils.findBuilding(this.m_9236_().m_5776_(), blockPos.m_7494_().m_7918_(x, y, z));
                        if (building == null) continue;
                        buildings.add(building);
                    }
                }
            }
            for (BuildingPlacement building : buildings) {
                building.destroyRandomBlocks((int)(maceSlam.damage / 2.0f));
            }
            for (LivingEntity hitEntity : hitEntities) {
                boolean hurt;
                if (hitEntity instanceof Unit) {
                    Unit unit = (Unit)hitEntity;
                    Unit.fullResetBehaviours(unit);
                    hitEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistrar.STUN.get(), maceSlam.stunDuration));
                } else {
                    hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, maceSlam.stunDuration, 63));
                }
                if (!(hurt = hitEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), maceSlam.damage))) continue;
                float kb = (float)this.m_21133_(Attributes.f_22282_);
                hitEntity.m_147240_((double)(kb * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                this.m_21335_((Entity)hitEntity);
            }
        }
    }

    public void tauntingCry() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List<AttackerUnit> tauntableUnits = MiscUtil.getEntitiesWithinRange(this.m_20182_(), 6.0f, Mob.class, this.m_9236_()).stream().filter(e -> {
            if (!(e instanceof AttackerUnit)) return false;
            AttackerUnit unit = (AttackerUnit)e;
            if (List.of(Relationship.OWNED, Relationship.FRIENDLY).contains((Object)UnitServerEvents.getUnitToEntityRelationship((Unit)((Object)unit), (Entity)this))) return false;
            return true;
        }).map(e -> (AttackerUnit)e).toList();
        TauntingCry tauntingCry = this.getTauntingCry();
        if (tauntingCry != null && tauntingCry.getRank(this) > 0) {
            for (AttackerUnit unit : tauntableUnits) {
                Unit.fullResetBehaviours((Unit)((Object)unit));
                unit.setUnitAttackTargetForced((LivingEntity)this);
                ((LivingEntity)unit).m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistrar.UNCONTROLLABLE.get(), tauntingCry.duration));
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, tauntingCry.duration, 2));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, tauntingCry.duration, 2));
            this.tauntingCryTicksLeft = tauntingCry.duration;
            this.updateKnockbackResistance();
            SoundClientboundPacket.playSoundAtPos(SoundAction.HEROISM, this.m_20097_().m_7494_());
        }
    }

    public void tickTauntingCry() {
        if (this.tauntingCryTicksLeft > 0) {
            --this.tauntingCryTicksLeft;
        }
        if (this.tauntingCryTicksLeft == 1) {
            this.updateKnockbackResistance();
        }
    }

    public void tickBattleRage() {
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        BattleRagePassive battleRage = this.getBattleRage();
        if (battleRage != null && battleRage.getRank(this) > 0) {
            float percentRage = 1.0f - this.m_21223_() / this.m_21233_();
            this.m_5634_(percentRage * battleRage.maxHpRegen);
            this.updateAbilityButtons();
        }
    }

    public float m_6134_() {
        return 1.0f + 0.6f * ((float)this.avatarScaleTicks / 40.0f);
    }

    private void tickAvatar() {
        if (this.avatarTicksLeft > 0) {
            --this.avatarTicksLeft;
            this.m_21195_(MobEffects.f_19597_);
            if (this.avatarTicksLeft <= 0) {
                this.disableAvatar();
                this.setStatsForLevel();
            }
        }
        if (this.avatarScalingStarted && this.avatarScaleTicks < 40) {
            ++this.avatarScaleTicks;
            if ((float)this.avatarScaleTicks == 30.0f) {
                this.animateScaleReducing = true;
            }
            this.m_20090_();
            this.m_6210_();
        } else if (!this.avatarScalingStarted && this.avatarScaleTicks > 0) {
            --this.avatarScaleTicks;
            this.m_20090_();
            this.m_6210_();
        }
    }

    public void disableAvatar() {
        this.avatarScalingStarted = false;
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.deactivateAbilityClientside(this.m_19879_(), 3);
        }
    }

    public void enableAvatar() {
        this.avatarTicksLeft = 1200;
        this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, this.avatarTicksLeft, 0));
        this.updateKnockbackResistance();
        this.setStatsForLevel();
        this.m_5634_(100.0f);
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.activateAbilityClientside(this.m_19879_(), 4);
        }
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (this.avatarTicksLeft <= 0) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    @Override
    public void activateAbilityClientside(int abilityIndex) {
        if (this.m_9236_().m_5776_()) {
            if (abilityIndex == 3) {
                this.avatarScalingStarted = true;
            } else if (abilityIndex == 4) {
                this.enableAvatar();
            }
        }
    }

    @Override
    public void deactivateAbilityClientside(int abilityIndex) {
        if (this.m_9236_().m_5776_() && abilityIndex == 3) {
            this.avatarScalingStarted = false;
        }
    }

    static {
        ABILITIES.add(new MaceSlam());
        ABILITIES.add(new TauntingCry());
        ABILITIES.add(new BattleRagePassive());
        ABILITIES.add(new Avatar());
        ownerDataAccessor = SynchedEntityData.m_135353_(RoyalGuardUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

