/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityServerboundPacket;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class HeroAbility
extends Ability {
    public final HeroUnit hero;
    public int rank = 0;
    public final int maxRank;

    public HeroAbility(HeroUnit hero, int maxRank, UnitAction action, int cooldownMax, float range, float radius, boolean canTargetEntities) {
        super(action, ((Entity)hero).m_9236_(), cooldownMax, range, radius, canTargetEntities);
        this.hero = hero;
        this.maxRank = maxRank;
    }

    public int getLevelRequirement() {
        if (this.maxRank <= 1) {
            return 6;
        }
        return this.rank * 2 + 1;
    }

    public boolean rankUp() {
        if (this.rank < this.maxRank && this.hero.getSkillPoints() > 0 && this.hero.getHeroLevel() >= this.getLevelRequirement()) {
            ++this.rank;
            this.hero.setSkillPoints(this.hero.getSkillPoints() - 1);
            if (((LivingEntity)this.hero).m_9236_().f_46443_) {
                this.hero.updateAbilityButtons();
            }
            return true;
        }
        return false;
    }

    public void updateStatsForRank() {
    }

    protected String rankString() {
        return this.rank > 0 ? I18n.m_118938_((String)"abilities.reignofnether.rank", (Object[])new Object[]{this.rank}) : I18n.m_118938_((String)"abilities.reignofnether.unlearnt", (Object[])new Object[0]);
    }

    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of();
    }

    public List<FormattedCharSequence> getTooltipLines() {
        return List.of();
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return null;
    }

    public Button getRankUpButton() {
        return null;
    }

    protected Button getRankUpButtonProtected(String name, ResourceLocation resourceLocation) {
        Button button = new Button(name, 14, new ResourceLocation("reignofnether", "textures/hud/level_up_skill.png"), (Keybinding)null, () -> false, () -> !this.hero.isRankUpMenuOpen() || this.rank >= this.maxRank, () -> this.hero.getSkillPoints() > 0 && this.hero.getHeroLevel() >= this.getLevelRequirement(), () -> {
            if (this.rankUp()) {
                AbilityServerboundPacket.rankUpAbility(((Entity)this.hero).m_19879_(), this.action);
                this.hero.updateAbilityButtons();
            }
            if (this.hero.getSkillPoints() <= 0) {
                this.hero.showRankUpMenu(false);
            }
        }, null, this.getRankUpTooltipLines());
        button.bgIconResource = resourceLocation;
        return button;
    }

    public static Button getRankUpMenuButton(HeroUnit hero) {
        Button menuButton = new Button("Rank up abilities", 14, hero.isRankUpMenuOpen() ? new ResourceLocation("reignofnether", "textures/hud/cross.png") : new ResourceLocation("reignofnether", "textures/hud/tick.png"), Keybindings.keyU, () -> false, () -> hero.getHeroLevel() >= 10 && hero.getSkillPoints() <= 0, () -> true, () -> hero.showRankUpMenu(!hero.isRankUpMenuOpen()), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.rank_up_menu", (Object[])new Object[]{hero.getSkillPoints()}), true)));
        menuButton.isFlashing = () -> !hero.isRankUpMenuOpen() && hero.getSkillPoints() > 0;
        return menuButton;
    }

    public Style getLevelReqStyle() {
        return Style.f_131099_.m_178520_(this.hero.getHeroLevel() >= this.getLevelRequirement() ? 65280 : 0xFF0000);
    }
}

