/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;

public class CallToArmsBuilding
extends Ability {
    private static final int RANGE = 60;

    public CallToArmsBuilding(Level level) {
        super(UnitAction.CALL_TO_ARMS_BUILDING, level, 0, 60.0f, 0.0f, false, false);
        this.defaultHotkey = Keybindings.keyV;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Call To Arms (Building)", new ResourceLocation("minecraft", "textures/item/bell.png"), hotkey, () -> false, () -> false, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.CALL_TO_ARMS_BUILDING), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_to_arms_building", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_to_arms_building.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_to_arms_building.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.call_to_arms_building.tooltip3", (Object[])new Object[]{60}), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, BuildingPlacement buildingUsing, BlockPos targetBp) {
        List<VillagerUnit> nearbyUnits = MiscUtil.getEntitiesWithinRange(new Vector3d((double)buildingUsing.centrePos.m_123341_(), (double)buildingUsing.centrePos.m_123342_(), (double)buildingUsing.centrePos.m_123343_()), this.range, VillagerUnit.class, buildingUsing.getLevel()).stream().filter(u -> u.getOwnerName().equals(buildingUsing.ownerName)).toList();
        for (VillagerUnit vUnit : nearbyUnits) {
            Unit.resetBehaviours(vUnit);
            WorkerUnit.resetBehaviours(vUnit);
            vUnit.callToArmsGoal.setNearestTownCentreAsTarget();
        }
        if (!level.m_5776_()) {
            SoundClientboundPacket.playSoundAtPos(SoundAction.BELL, buildingUsing.centrePos);
            CompletableFuture.delayedExecutor(300L, TimeUnit.MILLISECONDS).execute(() -> SoundClientboundPacket.playSoundAtPos(SoundAction.BELL, buildingUsing.centrePos));
        }
    }
}

