/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.EnchantAbility;
import com.solegendary.reignofnether.ability.EnchantAbilityServerboundPacket;
import com.solegendary.reignofnether.building.buildings.placements.LibraryPlacement;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class EnchantSharpness
extends EnchantAbility {
    private static final UnitAction ENCHANT_ACTION = UnitAction.ENCHANT_SHARPNESS;
    public static final Enchantment actualEnchantment = Enchantments.f_44977_;
    public static final int enchantLevel = 2;

    public EnchantSharpness(LibraryPlacement library) {
        super(ENCHANT_ACTION, library, ResourceCosts.ENCHANT_SHARPNESS);
        this.defaultHotkey = Keybindings.keyE;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Sharpness Enchantment", new ResourceLocation("minecraft", "textures/item/diamond_axe.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == ENCHANT_ACTION || this.library.autoCastEnchant == this, () -> false, () -> this.library.getUpgradeLevel() > 0, () -> CursorClientEvents.setLeftClickAction(ENCHANT_ACTION), () -> {
            EnchantAbilityServerboundPacket.setAutocastEnchant(ENCHANT_ACTION, this.library.originPos);
            this.library.autoCastEnchant = this.library.autoCastEnchant == this ? null : this;
        }, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"ability.reignofnether.enchant.sharpness", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(this.cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"ability.reignofnether.enchant.sharpness.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"ability.reignofnether.enchant.sharpness.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"ability.reignofnether.enchant.sharpness.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.autocast", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public boolean isCorrectUnitAndEquipment(LivingEntity entity) {
        return entity instanceof VindicatorUnit && entity.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof AxeItem;
    }

    @Override
    public boolean hasAnyEnchant(LivingEntity entity) {
        return !entity.m_6844_(EquipmentSlot.MAINHAND).getAllEnchantments().isEmpty();
    }

    @Override
    protected boolean hasSameEnchant(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.MAINHAND).getAllEnchantments().containsKey(actualEnchantment);
    }

    @Override
    protected void doEnchant(LivingEntity entity) {
        ItemStack item = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (item != ItemStack.f_41583_) {
            EnchantmentHelper.m_44865_(new HashMap(), (ItemStack)item);
            item.m_41663_(actualEnchantment, 2);
        }
    }
}

