/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.buildings.villagers.Castle;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class PromoteIllager
extends Ability {
    private static final int CD_MAX = 2400;
    private static final int RANGE = 20;
    private static final int BUFF_RANGE = 10;
    LivingEntity promotedIllager = null;
    BuildingPlacement buildingPlacement;

    public PromoteIllager(BuildingPlacement buildingPlacement) {
        super(UnitAction.PROMOTE_ILLAGER, buildingPlacement.getLevel(), 2400, 20.0f, 0.0f, true, true);
        this.buildingPlacement = buildingPlacement;
        this.defaultHotkey = Keybindings.keyW;
    }

    public static void checkAndApplyBuff(LivingEntity entity) {
        if (!entity.m_9236_().m_5776_() && entity instanceof Unit) {
            Unit captainUnit = (Unit)entity;
            if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem) {
                List<Mob> nearbyMobs = MiscUtil.getEntitiesWithinRange(new Vector3d(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_), 10.0f, Mob.class, entity.m_9236_());
                for (Mob mob : nearbyMobs) {
                    Unit unit;
                    if (!(mob instanceof Unit) || !(unit = (Unit)mob).getOwnerName().equals(captainUnit.getOwnerName())) continue;
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2, 0));
                }
            }
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Promote Illager", new ResourceLocation("reignofnether", "textures/icons/items/ominous_banner.png"), hotkey, () -> false, () -> {
            Building patt3718$temp = this.buildingPlacement.getBuilding();
            if (patt3718$temp instanceof Castle) {
                Castle castle = (Castle)patt3718$temp;
                return this.buildingPlacement.getUpgradeLevel() == 0;
            }
            return true;
        }, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.PROMOTE_ILLAGER), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.promote_illager", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"abilities.reignofnether.promote_illager.tooltip1", (Object[])new Object[]{120}) + "20"), (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.promote_illager.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.promote_illager.tooltip3", (Object[])new Object[]{10}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.promote_illager.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, BuildingPlacement buildingUsing, LivingEntity targetEntity) {
        Vec3 pos = targetEntity.m_146892_();
        if (buildingUsing.centrePos.m_203198_(pos.f_82479_, pos.f_82480_, pos.f_82481_) > 400.0) {
            if (level.m_5776_()) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.promote_illager.error1", (Object[])new Object[0]));
            }
        } else if (targetEntity instanceof VindicatorUnit || targetEntity instanceof PillagerUnit || targetEntity instanceof EvokerUnit) {
            Unit unit = (Unit)targetEntity;
            if (targetEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem) {
                if (level.m_5776_()) {
                    HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.promote_illager.error2", (Object[])new Object[0]));
                }
                return;
            }
            if (!unit.getOwnerName().equals(this.buildingPlacement.ownerName)) {
                if (level.m_5776_()) {
                    HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.promote_illager.error3", (Object[])new Object[0]));
                }
                return;
            }
            if (this.promotedIllager != null && this.promotedIllager.m_6084_() && this.promotedIllager.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem) {
                this.promotedIllager.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_41852_));
            }
            this.promotedIllager = targetEntity;
            this.promotedIllager.m_8061_(EquipmentSlot.HEAD, Raid.m_37779_());
            if (!level.m_5776_()) {
                MiscUtil.shootFirework(level, this.promotedIllager.m_146892_());
            }
            this.setToMaxCooldown();
        } else if (level.m_5776_()) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.promote_illager.error4", (Object[])new Object[0]));
        }
    }
}

