/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class SpiderClimbing
extends Ability {
    private final SpiderUnit spiderUnit;

    public SpiderClimbing(SpiderUnit unit) {
        super(UnitAction.NONE, unit.m_9236_(), 0, 0.0f, 0.0f, false, false);
        this.spiderUnit = unit;
        this.autocastEnableAction = UnitAction.ENABLE_SPIDER_CLIMBING;
        this.autocastDisableAction = UnitAction.DISABLE_SPIDER_CLIMBING;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        ResourceLocation rlLadder = new ResourceLocation("minecraft", "textures/block/ladder.png");
        ResourceLocation rlBarrier = new ResourceLocation("reignofnether", "textures/icons/items/barrier.png");
        AbilityButton ab = new AbilityButton("Toggle Wall Climbing", this.spiderUnit.isWallClimbing() ? rlLadder : rlBarrier, hotkey, () -> false, () -> false, () -> true, () -> this.toggleAutocast(), null, List.of(this.spiderUnit.isWallClimbing() ? MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.spider_climbing_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.spider_climbing_off", (Object[])new Object[0]))), this);
        if (!this.spiderUnit.isWallClimbing()) {
            ab.bgIconResource = rlLadder;
        }
        return ab;
    }

    @Override
    public void setAutocast(boolean value) {
        super.setAutocast(value);
        if (this.getAutocast() && !this.spiderUnit.isWallClimbing() || !this.getAutocast() && this.spiderUnit.isWallClimbing()) {
            this.spiderUnit.toggleWallClimbing();
        }
        if (this.level.m_5776_()) {
            this.spiderUnit.updateAbilityButtons();
        }
    }

    @Override
    public boolean shouldResetBehaviours() {
        return false;
    }
}

