/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.monster;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.time.TimeServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BloodMoon
extends HeroAbility {
    public static final int SPAWN_INTERVAL_TICKS = 120;
    public static final int CHANNEL_TICKS = 40;
    private static final int CD_MAX = 7200;
    public static final int DURATION = 1200;
    public static final int BONUS_DURATION_PER_SOUL_RANK = 200;

    public BloodMoon(HeroUnit hero) {
        super(hero, 1, UnitAction.BLOOD_MOON, 7200, 0.0f, 0.0f, false);
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Blood Moon", new ResourceLocation("minecraft", "textures/block/redstone_block.png"), hotkey, () -> false, () -> this.rank == 0, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.BLOOD_MOON), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Blood Moon", new ResourceLocation("minecraft", "textures/block/redstone_block.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon", (Object[])new Object[0]), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.stats", (Object[])new Object[]{360})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip3", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip4", (Object[])new Object[]{60, 10})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip3", (Object[])new Object[0])));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        this.use(level, unitUsing);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        this.use(level, unitUsing);
    }

    private void use(Level level, Unit unitUsing) {
        boolean isBloodMoonActive;
        if (level.m_5776_()) {
            isBloodMoonActive = TimeClientEvents.isBloodMoonActive();
            if (isBloodMoonActive) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.already_active", (Object[])new Object[0]));
            }
        } else {
            isBloodMoonActive = TimeServerEvents.isBloodMoonActive();
        }
        if (!isBloodMoonActive) {
            ((NecromancerUnit)unitUsing).getCastBloodMoonGoal().setAbility(this);
            ((NecromancerUnit)unitUsing).getCastBloodMoonGoal().startCasting();
        }
    }
}

