/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AlliancesClient {
    private static final Map<String, Set<String>> alliances = new HashMap<String, Set<String>>();

    public static void addAlliance(String owner1, String owner2) {
        alliances.computeIfAbsent(owner1, k -> new HashSet()).add(owner2);
        alliances.computeIfAbsent(owner2, k -> new HashSet()).add(owner1);
    }

    public static void removeAlliance(String owner1, String owner2) {
        Set<String> alliesOfOwner2;
        Set<String> alliesOfOwner1 = alliances.get(owner1);
        if (alliesOfOwner1 != null) {
            alliesOfOwner1.remove(owner2);
            if (alliesOfOwner1.isEmpty()) {
                alliances.remove(owner1);
            }
        }
        if ((alliesOfOwner2 = alliances.get(owner2)) != null) {
            alliesOfOwner2.remove(owner1);
            if (alliesOfOwner2.isEmpty()) {
                alliances.remove(owner2);
            }
        }
    }

    public static boolean isAllied(String owner1, String owner2) {
        return alliances.getOrDefault(owner1, Collections.emptySet()).contains(owner2);
    }

    public static Set<String> getAllAllies(String owner) {
        return alliances.getOrDefault(owner, Collections.emptySet());
    }

    public static Set<String> getAllConnectedAllies(String owner) {
        HashSet<String> allAllies = new HashSet<String>();
        AlliancesClient.findAllConnectedAllies(owner, allAllies);
        return allAllies;
    }

    private static void findAllConnectedAllies(String owner, Set<String> visited) {
        if (!visited.contains(owner)) {
            visited.add(owner);
            for (String ally : AlliancesClient.getAllAllies(owner)) {
                AlliancesClient.findAllConnectedAllies(ally, visited);
            }
        }
    }

    public static void resetAllAlliances() {
        alliances.clear();
    }
}

