/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public abstract class Building {
    public String name;
    public String structureName;
    public ResourceLocation icon;
    public final boolean isCapitol;
    public Block portraitBlock;
    public boolean canAcceptResources = false;
    protected float explodeChance = 0.3f;
    protected float explodeRadius = 2.0f;
    protected float fireThreshold = 0.75f;
    protected float buildTimeModifier = 1.0f;
    protected float repairTimeModifier = 1.25f;
    public int captureRange = 20;
    public boolean capturable = false;
    public boolean invulnerable = false;
    public boolean shouldDestroyOnReset = true;
    public ResourceCost cost;
    public boolean selfBuilding = false;
    public final ArrayList<Block> startingBlockTypes = new ArrayList();

    public Building(String structureName, ResourceCost cost, boolean isCapitol) {
        this.structureName = structureName;
        this.cost = cost;
        this.isCapitol = isCapitol;
    }

    public float getMeleeDamageMult() {
        return 0.2f;
    }

    public ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(this.structureName, level);
    }

    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new BuildingPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), this.isCapitol);
    }

    protected static ArrayList<BuildingBlock> getCulledBlocks(ArrayList<BuildingBlock> blocks, Level level) {
        blocks.removeIf(b -> Building.shouldCullBlock(new BlockPos(0, 0, 0), b, level));
        return blocks;
    }

    public static boolean shouldCullBlock(BlockPos originPos, BuildingBlock b, Level level) {
        BlockState bs = b.getBlockState();
        boolean isFenceOrAir = b.getBlockState().m_60734_() instanceof AirBlock || b.getBlockState().m_60734_() instanceof FenceBlock;
        BlockPos bp = b.getBlockPos().m_121955_((Vec3i)originPos);
        BlockState bsWorld = level.m_8055_(bp);
        if (bsWorld.m_60734_() == Blocks.f_50080_) {
            return false;
        }
        if (bsWorld.equals(bs)) {
            return false;
        }
        if (!(!bsWorld.m_60795_() && bsWorld.m_60819_().m_76178_() || isFenceOrAir)) {
            return false;
        }
        if (BuildingUtils.isPosInsideAnyBuilding(level.f_46443_, bp)) {
            return true;
        }
        for (BlockPos bpAdj : List.of(bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
            BlockState bsWorldAdj = level.m_8055_(bpAdj);
            if (!isFenceOrAir || bsWorldAdj.m_60795_() || !BuildingUtils.isPosInsideAnyBuilding(level.f_46443_, bpAdj)) continue;
            return true;
        }
        return level.m_8055_(bp).m_280296_() || isFenceOrAir && level.m_8055_(bp.m_7495_()).m_280296_();
    }

    public abstract Faction getFaction();

    public int getUpgradeLevel(BuildingPlacement placement) {
        return 0;
    }

    public abstract AbilityButton getBuildButton(Keybinding var1);

    public boolean isTypeOf(Building building) {
        return this == building;
    }
}

