/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class InfernalPortal
extends ProductionBuilding {
    public static final String buildingName = "Infernal Portal";
    public static final String structureName = "infernal_portal";
    public static final ResourceCost cost = ResourceCosts.INFERNAL_PORTAL;

    public InfernalPortal() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50723_;
        this.icon = new ResourceLocation("minecraft", "textures/block/crying_obsidian.png");
        this.startingBlockTypes.add(Blocks.f_50197_);
        this.productions.add(ProductionItems.PIGLIN_MERCHANT, Keybindings.keyQ);
        this.productions.add(ProductionItems.PIGLIN_MERCHANT_REVIVE, Keybindings.keyQ);
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public PortalPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new PortalPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false);
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new AbilityButton(name, new ResourceLocation("minecraft", "textures/block/crying_obsidian.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.INFERNAL_PORTAL, () -> !SandboxClientEvents.isSandboxPlayer(), () -> BuildingClientEvents.hasFinishedBuilding(Buildings.CENTRAL_PORTAL) || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Buildings.INFERNAL_PORTAL), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"buildings.piglins.reignofnether.infernal_portal", (Object[])new Object[0]), true), ResourceCosts.getFormattedCost(cost), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"buildings.piglins.reignofnether.infernal_portal.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"buildings.piglins.reignofnether.infernal_portal.tooltip2", (Object[])new Object[0]))), null);
    }
}

