/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.ability.abilities.ConnectPortal;
import com.solegendary.reignofnether.ability.abilities.DisconnectPortal;
import com.solegendary.reignofnether.ability.abilities.GotoPortal;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.AbstractPortal;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class PortalTransport
extends AbstractPortal {
    public static final String buildingName = "Transport Portal";
    public static final String structureName = "portal_transport";
    public static final ResourceCost cost = ResourceCosts.BASIC_PORTAL;

    public PortalTransport() {
        super(structureName, cost);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50537_;
        this.icon = new ResourceLocation("minecraft", "textures/block/blue_glazed_terracotta.png");
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50060_);
    }

    @Override
    public PortalPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        PortalPlacement portalPlacement = new PortalPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false);
        ConnectPortal connectPortal = new ConnectPortal(portalPlacement);
        portalPlacement.getAbilities().add(connectPortal);
        GotoPortal gotoPortal = new GotoPortal(portalPlacement);
        portalPlacement.getAbilities().add(gotoPortal);
        DisconnectPortal disconnectPortal = new DisconnectPortal(portalPlacement);
        portalPlacement.getAbilities().add(disconnectPortal);
        return portalPlacement;
    }

    @Override
    public int getUpgradeLevel(BuildingPlacement placement) {
        return 1;
    }
}

