/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class RangeIndicatorProductionPlacement
extends ProductionPlacement
implements RangeIndicator {
    int range;
    boolean showOnlyWhenSelected;
    boolean checkUpgraded;
    private final Set<BlockPos> borderBps = new HashSet<BlockPos>();

    public RangeIndicatorProductionPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol, int range, boolean showOnlyWhenSelected, boolean checkUpgraded) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        this.range = range;
        this.showOnlyWhenSelected = showOnlyWhenSelected;
        this.checkUpgraded = checkUpgraded;
        this.updateBorderBps();
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
    }

    public int getRange() {
        return (!this.checkUpgraded || this.getUpgradeLevel() > 0) && this.isBuilt ? this.range : 0;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.borderBps.clear();
        this.borderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.range - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.borderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return this.showOnlyWhenSelected;
    }
}

