/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Blocks;

public class ArcaneTower
extends ProductionBuilding {
    public static final String buildingName = "Arcane Tower";
    public static final String structureName = "arcane_tower";
    public static final ResourceCost cost = ResourceCosts.ARCANE_TOWER;

    public ArcaneTower() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_152490_;
        this.icon = new ResourceLocation("minecraft", "textures/block/amethyst_block.png");
        this.startingBlockTypes.add(Blocks.f_50222_);
        this.startingBlockTypes.add(Blocks.f_50611_);
        this.startingBlockTypes.add(Blocks.f_50641_);
        this.startingBlockTypes.add(Blocks.f_50387_);
        this.buildTimeModifier = 0.7f;
        this.explodeChance = 0.2f;
        this.productions.add(ProductionItems.WITCH, Keybindings.keyQ);
        this.productions.add(ProductionItems.EVOKER, Keybindings.keyW);
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new AbilityButton(name, new ResourceLocation("minecraft", "textures/block/amethyst_block.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.ARCANE_TOWER, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.BARRACKS) || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Buildings.ARCANE_TOWER), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.arcane_tower", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.arcane_tower.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.arcane_tower.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level, BlockPos centrePos) {
        return super.getIndoorSpawnPoint(level, centrePos).m_7918_(0, -10, 0);
    }
}

