/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production;

import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;

public abstract class HeroProductionItem
extends ProductionItem {
    public final ResourceLocation iconRl;
    public final String itemName;

    public HeroProductionItem(ResourceCost cost, String itemName, ResourceLocation iconRl) {
        super(cost);
        this.onComplete = (level, placement) -> {
            if (!level.m_5776_() && !this.heroOwned(level.m_5776_(), placement.ownerName)) {
                placement.produceUnit((ServerLevel)level, this.getHeroEntityType(), placement.ownerName, true);
            }
        };
        this.itemName = itemName;
        this.iconRl = iconRl;
    }

    @Override
    public String getItemName() {
        return this.itemName;
    }

    protected boolean heroOwned(boolean isClientside, String ownerName) {
        String heroName = this.getHeroEntityType().m_20675_();
        return !HeroUnit.getHeroes(isClientside, ownerName, heroName).isEmpty() || HeroUnit.getFallenHero(isClientside, ownerName, heroName) != null;
    }

    protected EntityType<? extends HeroUnit> getHeroEntityType() {
        return null;
    }

    @Override
    public Button getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new Button(this.getItemName(), 14, this.iconRl, (Keybinding)null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.originPos, this, first), null, null);
    }
}

